/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.FilterNoMissingValuesFilter", "de.lmu.ifi.dbs.elki.datasource.filter.NoMissingValuesFilter"})
public class NoMissingValuesFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(NoMissingValuesFilter.class);
    private int cols = 0;

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int n) {
        return this.source.data(n);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event event = this.source.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    return event;
                }
                case META_CHANGED: {
                    this.cols = this.source.getMeta().size();
                    return event;
                }
                case NEXT_OBJECT: {
                    boolean bl = true;
                    for (int i = 0; i < this.cols; ++i) {
                        if (this.source.data(i) != null) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue block5;
                    return event;
                }
            }
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        int n;
        if (LOG.isDebugging()) {
            LOG.debug("Filtering the data set");
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (n = 0; n < multipleObjectsBundle.metaLength(); ++n) {
            multipleObjectsBundle2.appendColumn(multipleObjectsBundle.meta(n), new ArrayList());
        }
        for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
            boolean bl = true;
            for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                if (multipleObjectsBundle.data(n, i) != null) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            multipleObjectsBundle2.appendSimple(multipleObjectsBundle.getRow(n));
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NoMissingValuesFilter makeInstance() {
            return new NoMissingValuesFilter();
        }
    }
}

