/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.BestFitEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseCDFNormalization"})
public class AttributeWiseCDFNormalization<V extends NumberVector>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseCDFNormalization.class);
    private List<DistributionEstimator<?>> estimators;
    private List<Distribution> dists;
    protected NumberVector.Factory<V> factory;

    public AttributeWiseCDFNormalization(List<DistributionEstimator<?>> list) {
        this.estimators = list;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        if (multipleObjectsBundle.dataLength() == 0) {
            return multipleObjectsBundle;
        }
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(simpleTypeInformation)) continue;
            List<?> list2 = list;
            VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
            this.factory = FilterUtil.guessFactory(vectorFieldTypeInformation);
            int n = vectorFieldTypeInformation.getDimensionality();
            this.dists = new ArrayList<Distribution>(n);
            double[] dArray = this.estimators.size() > 1 ? new double[list2.size()] : null;
            Adapter adapter = new Adapter();
            for (int j = 0; j < n; ++j) {
                adapter.dim = j;
                Distribution distribution = this.estimators.size() == 1 ? this.estimators.get(0).estimate(list2, adapter) : this.findBestFit(list2, adapter, j, dArray);
                if (distribution instanceof UniformDistribution) {
                    distribution = this.constantZero(list2, adapter) ? new UniformDistribution(0.0, 1.0) : distribution;
                }
                this.dists.add(distribution);
            }
            double[] dArray2 = new double[n];
            for (int j = 0; j < multipleObjectsBundle.dataLength(); ++j) {
                NumberVector numberVector = (NumberVector)list2.get(j);
                for (int k = 0; k < n; ++k) {
                    dArray2[k] = this.dists.get(k).cdf(numberVector.doubleValue(k));
                }
                list2.set(j, this.factory.newNumberVector(dArray2));
            }
        }
        return multipleObjectsBundle;
    }

    protected Distribution findBestFit(List<V> list, Adapter adapter, int n, double[] dArray) {
        Distribution distribution = null;
        double d = Double.POSITIVE_INFINITY;
        block2: for (DistributionEstimator<Double> distributionEstimator : this.estimators) {
            try {
                Object obj = distributionEstimator.estimate(list, adapter);
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = obj.cdf(((NumberVector)list.get(i)).doubleValue(n));
                    if (Double.isNaN(dArray[i])) {
                        LOG.warning("Got NaN after fitting " + distributionEstimator.toString() + ": " + obj.toString());
                        continue block2;
                    }
                    if (!Double.isInfinite(dArray[i])) continue;
                    LOG.warning("Got infinite value after fitting " + distributionEstimator.toString() + ": " + obj.toString());
                    continue block2;
                }
                Arrays.sort(dArray);
                double d2 = KolmogorovSmirnovTest.simpleTest(dArray);
                if (LOG.isVeryVerbose()) {
                    LOG.veryverbose("Estimator " + distributionEstimator.toString() + " (" + obj.toString() + ") has maximum deviation " + d2 + " for dimension " + n);
                }
                if (distribution != null && !(d2 < d)) continue;
                distribution = obj;
                d = d2;
            }
            catch (ArithmeticException arithmeticException) {
                if (!LOG.isVeryVerbose()) continue;
                LOG.veryverbose("Fitting distribution " + distributionEstimator + " failed: " + arithmeticException.getMessage());
            }
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Best fit for dimension " + n + ": " + distribution.toString());
        }
        return distribution;
    }

    protected boolean constantZero(List<V> list, Adapter adapter) {
        int n = adapter.size(list);
        for (int i = 0; i < n; ++i) {
            if (adapter.get(list, i) == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public V restore(V v) throws NonNumericFeaturesException {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("normalization class: ").append(this.getClass().getName());
        stringBuilder.append('\n');
        stringBuilder.append("normalization distributions: ");
        boolean bl = true;
        for (DistributionEstimator<?> distributionEstimator : this.estimators) {
            if (!bl) {
                stringBuilder.append(',');
            }
            bl = false;
            stringBuilder.append(distributionEstimator.getClass().getSimpleName());
        }
        return stringBuilder.toString();
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DISTRIBUTIONS_ID = new OptionID("normalize.distributions", "A list of the distribution estimators to try.");
        private List<DistributionEstimator<?>> estimators;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(DISTRIBUTIONS_ID, DistributionEstimator.class);
            ArrayList<Class<BestFitEstimator>> arrayList = new ArrayList<Class<BestFitEstimator>>(1);
            arrayList.add(BestFitEstimator.class);
            objectListParameter.setDefaultValue(arrayList);
            if (parameterization.grab(objectListParameter)) {
                this.estimators = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected AttributeWiseCDFNormalization<V> makeInstance() {
            return new AttributeWiseCDFNormalization(this.estimators);
        }
    }

    private static class Adapter
    implements NumberArrayAdapter<Double, List<? extends NumberVector>> {
        int dim;

        private Adapter() {
        }

        @Override
        public int size(List<? extends NumberVector> list) {
            return list.size();
        }

        @Override
        public Double get(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return this.getDouble(list, n);
        }

        @Override
        public double getDouble(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).doubleValue(this.dim);
        }

        @Override
        public float getFloat(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).floatValue(this.dim);
        }

        @Override
        public int getInteger(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).intValue(this.dim);
        }

        @Override
        public short getShort(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).shortValue(this.dim);
        }

        @Override
        public long getLong(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).longValue(this.dim);
        }

        @Override
        public byte getByte(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).byteValue(this.dim);
        }
    }
}

