/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseMADNormalization"})
public class AttributeWiseMADNormalization<V extends NumberVector>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMADNormalization.class);
    protected NumberVector.Factory<V> factory;
    private double[] median = new double[0];
    private double[] imadsigma = new double[0];

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        if (multipleObjectsBundle.dataLength() == 0) {
            return multipleObjectsBundle;
        }
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            int n;
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(simpleTypeInformation)) continue;
            List<?> list2 = list;
            VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
            this.factory = FilterUtil.guessFactory(vectorFieldTypeInformation);
            int n2 = vectorFieldTypeInformation.getDimensionality();
            this.median = new double[n2];
            this.imadsigma = new double[n2];
            double[] dArray = new double[list2.size()];
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Analyzing data", n2, LOG) : null;
            for (int j = 0; j < n2; ++j) {
                double d;
                for (int k = 0; k < dArray.length; ++k) {
                    dArray[k] = ((NumberVector)list2.get(k)).doubleValue(j);
                }
                this.median[j] = d = QuickSelect.median(dArray);
                int n3 = 0;
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = Math.abs(dArray[n] - d);
                    if (dArray[n] != 0.0) continue;
                    ++n3;
                }
                if (n3 < dArray.length >>> 1) {
                    this.imadsigma[j] = 0.6744897501960817 / QuickSelect.median(dArray);
                } else if (n3 == dArray.length) {
                    LOG.warning("Constant attribute detected. Using MAD=1.");
                    this.imadsigma[j] = 1.0;
                } else {
                    n = n3 + (dArray.length - n3 >> 1);
                    double d2 = 0.5 + (double)n * 0.5 / (double)dArray.length;
                    this.imadsigma[j] = NormalDistribution.quantile(0.0, 1.0, d2) / QuickSelect.quickSelect(dArray, n);
                    LOG.warning("Near-constant attribute detected. Using modified MAD.");
                }
                LOG.incrementProcessed(finiteProgress);
            }
            LOG.ensureCompleted(finiteProgress);
            FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("Data normalization", multipleObjectsBundle.dataLength(), LOG) : null;
            double[] dArray2 = new double[n2];
            for (int j = 0; j < multipleObjectsBundle.dataLength(); ++j) {
                NumberVector numberVector = (NumberVector)list2.get(j);
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = this.normalize(n, numberVector.doubleValue(n));
                }
                list2.set(j, this.factory.newNumberVector(dArray2));
                LOG.incrementProcessed(finiteProgress2);
            }
            LOG.ensureCompleted(finiteProgress2);
        }
        return multipleObjectsBundle;
    }

    @Override
    public V restore(V v) throws NonNumericFeaturesException {
        if (v.getDimensionality() == this.median.length) {
            double[] dArray = new double[v.getDimensionality()];
            for (int i = 0; i < v.getDimensionality(); ++i) {
                dArray[i] = this.restore(i, v.doubleValue(i));
            }
            return this.factory.newNumberVector(dArray);
        }
        throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + v.getDimensionality() + " former dimensionality: " + this.median.length);
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) throws NonNumericFeaturesException {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    private double normalize(int n, double d) {
        return (d - this.median[n]) * this.imadsigma[n];
    }

    private double restore(int n, double d) {
        return d / this.imadsigma[n] + this.median[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("normalization class: ").append(this.getClass().getName());
        stringBuilder.append('\n');
        stringBuilder.append("normalization median: ").append(FormatUtil.format(this.median));
        stringBuilder.append('\n');
        stringBuilder.append("normalization scaling factor: ").append(FormatUtil.format(this.imadsigma));
        return stringBuilder.toString();
    }
}

