/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractStreamNormalization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class InstanceMinMaxNormalization<V extends NumberVector>
extends AbstractStreamNormalization<V> {
    private double min;
    private double max;
    private int multiplicity;

    public InstanceMinMaxNormalization(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public InstanceMinMaxNormalization() {
        this(0.0, 1.0);
    }

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = v.getColumnVector().getArrayRef();
        if (this.multiplicity > 1) {
            int n;
            assert (dArray.length % this.multiplicity == 0) : "Vector length is not divisible by multiplicity?";
            double[] dArray2 = new double[this.multiplicity];
            double[] dArray3 = new double[this.multiplicity];
            for (n = 0; n < this.multiplicity; ++n) {
                dArray2[n] = Double.POSITIVE_INFINITY;
                dArray3[n] = Double.NEGATIVE_INFINITY;
            }
            n = 0;
            int n2 = 0;
            while (n < dArray.length) {
                double d = dArray[n];
                if (d == d) {
                    dArray2[n2] = dArray2[n2] < d ? dArray2[n2] : d;
                    dArray3[n2] = dArray3[n2] > d ? dArray3[n2] : d;
                }
                ++n;
                ++n2;
                n2 %= this.multiplicity;
            }
            for (n = 0; n < this.multiplicity; ++n) {
                if (!(dArray2[n] < dArray3[n])) continue;
                double d = (this.max - this.min) / (dArray3[n] - dArray2[n]);
                for (int i = 0; i < dArray.length; i += this.multiplicity) {
                    dArray[i] = (dArray[i] - dArray2[n]) * d + this.min;
                }
            }
            return this.factory.newNumberVector(dArray);
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i];
            if (d3 != d3) continue;
            d = d < d3 ? d : d3;
            d2 = d2 > d3 ? d2 : d3;
        }
        if (d < d2) {
            double d4 = (this.max - this.min) / (d2 - d);
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (dArray[i] - d) * d4 + this.min;
            }
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected void initializeOutputType(SimpleTypeInformation<V> simpleTypeInformation) {
        super.initializeOutputType(simpleTypeInformation);
        this.multiplicity = ((VectorTypeInformation)simpleTypeInformation).getMultiplicity();
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MIN_ID = new OptionID("normalization.min", "Minimum value to assign to objects.");
        public static final OptionID MAX_ID = new OptionID("normalization.max", "Maximum value to assign to objects.");
        private double min;
        private double max;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = (DoubleParameter)new DoubleParameter(MIN_ID, 0.0).setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.min = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(MAX_ID, 1.0).setOptional(true))) {
                this.max = doubleParameter.doubleValue();
            }
            parameterization.checkConstraint(new LessGlobalConstraint<Double>(doubleParameter2, doubleParameter));
        }

        @Override
        protected InstanceMinMaxNormalization<V> makeInstance() {
            return new InstanceMinMaxNormalization(this.min, this.max);
        }
    }
}

