/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractStreamNormalization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class Log1PlusNormalization<V extends NumberVector>
extends AbstractStreamNormalization<V> {
    public static final Log1PlusNormalization<NumberVector> STATIC = new Log1PlusNormalization(1.0);
    protected double boost;
    protected double scale;

    public Log1PlusNormalization(double d) {
        this.boost = d;
        this.scale = 1.0 / Math.log1p(d);
    }

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = v.doubleValue(i);
            dArray[i] = Math.log1p((dArray[i] > 0.0 ? dArray[i] : -dArray[i]) * this.boost) * this.scale;
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID BOOST_ID = new OptionID("log1pscale.boost", "Boosting factor. Larger values will yield a steeper curve.");
        protected double boost;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(BOOST_ID, 1.0).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.boost = doubleParameter.doubleValue();
            }
        }

        @Override
        protected Log1PlusNormalization<V> makeInstance() {
            return new Log1PlusNormalization(this.boost);
        }
    }
}

