/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ShuffleObjectsFilter"})
public class ShuffleObjectsFilter
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(ShuffleObjectsFilter.class);
    final RandomFactory rnd;

    public ShuffleObjectsFilter(RandomFactory randomFactory) {
        this.rnd = randomFactory;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        int n;
        int n2;
        if (LOG.isDebugging()) {
            LOG.debug("Shuffling the data set");
        }
        Random random = this.rnd.getSingleThreadedRandom();
        int n3 = multipleObjectsBundle.dataLength();
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = n3; n2 > 1; --n2) {
            n = random.nextInt(n2);
            int n4 = nArray[n];
            nArray[n] = nArray[n2 - 1];
            nArray[n2 - 1] = n4;
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (n = 0; n < multipleObjectsBundle.metaLength(); ++n) {
            List<?> list = multipleObjectsBundle.getColumn(n);
            ArrayList arrayList = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(list.get(nArray[i]));
            }
            multipleObjectsBundle2.appendColumn(multipleObjectsBundle.meta(n), arrayList);
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SEED_ID = new OptionID("shuffle.seed", "Seed for randomly shuffling the rows for the database. If the parameter is not set, a random seed will be used.");
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            RandomParameter randomParameter = new RandomParameter(SEED_ID);
            if (parameterization.grab(randomParameter)) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected ShuffleObjectsFilter makeInstance() {
            return new ShuffleObjectsFilter(this.rnd);
        }
    }
}

