/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.typeconversions.ClassLabelFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractSupervisedProjectionVectorFilter<V extends NumberVector>
implements ObjectFilter {
    protected int tdim;

    public AbstractSupervisedProjectionVectorFilter(int n) {
        this.tdim = n;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        Object object;
        Object object2;
        int n;
        int n2 = multipleObjectsBundle.dataLength();
        if (n2 == 0) {
            return multipleObjectsBundle;
        }
        List<?> list = null;
        for (n = 0; n < multipleObjectsBundle.metaLength(); ++n) {
            object2 = multipleObjectsBundle.meta(n);
            List<?> list2 = multipleObjectsBundle.getColumn(n);
            if (!TypeUtil.CLASSLABEL.isAssignableFromType((TypeInformation)object2)) continue;
            object = list2;
            list = object;
            break;
        }
        if (list == null) {
            this.getLogger().warning("No class label column found (try " + ClassLabelFilter.class.getSimpleName() + ") -- cannot run " + this.getClass().getSimpleName());
            return multipleObjectsBundle;
        }
        n = 0;
        object2 = new MultipleObjectsBundle();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            object = multipleObjectsBundle.meta(i);
            List<?> list3 = multipleObjectsBundle.getColumn(i);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)object)) {
                ((MultipleObjectsBundle)object2).appendColumn((SimpleTypeInformation<?>)object, list3);
                continue;
            }
            List<?> list4 = list3;
            VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)object;
            NumberVector.Factory factory = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
            int n3 = vectorFieldTypeInformation.getDimensionality();
            if (this.tdim > n3) {
                if (this.getLogger().isVerbose()) {
                    this.getLogger().verbose("Setting projection dimension to original dimension: projection dimension: " + this.tdim + " larger than original dimension: " + n3);
                }
                this.tdim = n3;
            }
            try {
                Matrix matrix = this.computeProjectionMatrix(list4, list, n3);
                for (int j = 0; j < n2; ++j) {
                    Vector vector = matrix.times(((NumberVector)list4.get(j)).getColumnVector());
                    Object v = factory.newNumberVector(vector);
                    list4.set(j, v);
                }
                ((MultipleObjectsBundle)object2).appendColumn(this.convertedType((SimpleTypeInformation<?>)object, factory), list3);
                n = 1;
                continue;
            }
            catch (Exception exception) {
                this.getLogger().error("Projection failed -- continuing with unprojected data!", exception);
                ((MultipleObjectsBundle)object2).appendColumn((SimpleTypeInformation<?>)object, list3);
            }
        }
        if (n == 0) {
            this.getLogger().warning("No vector field of fixed dimensionality found.");
            return multipleObjectsBundle;
        }
        return object2;
    }

    protected SimpleTypeInformation<?> convertedType(SimpleTypeInformation<?> simpleTypeInformation, NumberVector.Factory<V> factory) {
        return new VectorFieldTypeInformation(factory, this.tdim);
    }

    protected abstract Logging getLogger();

    protected abstract Matrix computeProjectionMatrix(List<V> var1, List<? extends ClassLabel> var2, int var3);

    protected <O> Map<O, TIntList> partition(List<? extends O> list) {
        HashMap<O, TIntList> hashMap = new HashMap<O, TIntList>();
        Iterator<O> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            O o = iterator.next();
            TIntList tIntList = (TIntList)hashMap.get(o);
            if (tIntList == null) {
                tIntList = new TIntArrayList();
                hashMap.put(o, tIntList);
            }
            tIntList.add(n);
            ++n;
        }
        return hashMap;
    }

    public static abstract class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID P_ID = new OptionID("projection.dim", "Projection dimensionality");
        protected int tdim;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(P_ID, 2);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.tdim = (Integer)intParameter.getValue();
            }
        }
    }
}

