/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseFloatVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.SparseNumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.map.TIntDoubleMap;
import java.util.regex.Pattern;

public class LibSVMFormatParser<V extends SparseNumberVector>
extends SparseNumberVectorLabelParser<V> {
    private static final Logging LOG = Logging.getLogger(LibSVMFormatParser.class);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+|:)");
    public static final Pattern COMMENT_PATTERN = Pattern.compile("#");

    public LibSVMFormatParser(SparseNumberVector.Factory<V> factory) {
        super(WHITESPACE_PATTERN, (String)null, COMMENT_PATTERN, (long[])null, factory);
    }

    @Override
    protected boolean parseLineInternal() {
        int n = 0;
        this.labels.add(this.tokenizer.getSubstring());
        this.tokenizer.advance();
        this.haslabels = true;
        while (this.tokenizer.valid()) {
            try {
                int n2 = (int)this.tokenizer.getLongBase10();
                this.tokenizer.advance();
                double d = this.tokenizer.getDouble();
                this.tokenizer.advance();
                n = Math.max(n, n2 + 1);
                this.values.put(n2, d);
            }
            catch (NumberFormatException numberFormatException) {
                String string = this.tokenizer.getSubstring();
                if (string.charAt(0) == '#') break;
                throw new RuntimeException("Parsing error in line " + this.reader.getLineNumber() + ": expected data, got " + string);
            }
        }
        this.curvec = this.sparsefactory.newNumberVector((TIntDoubleMap)this.values, n);
        this.curlbl = LabelList.make(this.labels);
        this.values.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends SparseNumberVector>
    extends NumberVectorLabelParser.Parameterizer<V> {
        @Override
        protected void getFactory(Parameterization parameterization) {
            ObjectParameter objectParameter = new ObjectParameter(VECTOR_TYPE_ID, (Class<?>)SparseNumberVector.Factory.class, SparseFloatVector.Factory.class);
            if (parameterization.grab(objectParameter)) {
                this.factory = (NumberVector.Factory)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.getFactory(parameterization);
        }

        @Override
        protected LibSVMFormatParser<V> makeInstance() {
            return new LibSVMFormatParser((SparseNumberVector.Factory)this.factory);
        }
    }
}

