/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.io.InputStream;

public class SimpleTransactionParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(SimpleTransactionParser.class);
    int numterms;
    TObjectIntMap<String> keymap;
    protected BundleMeta meta;
    BundleStreamSource.Event nextevent;
    BitVector curvec;
    TLongArrayList buf = new TLongArrayList();

    public SimpleTransactionParser(CSVReaderFormat cSVReaderFormat) {
        super(cSVReaderFormat);
        this.keymap = new TObjectIntHashMap(1001, 0.5f, -1);
    }

    @Override
    public void initStream(InputStream inputStream) {
        super.initStream(inputStream);
        this.nextevent = BundleStreamSource.Event.META_CHANGED;
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event event = this.nextevent;
            this.nextevent = null;
            return event;
        }
        try {
            if (this.reader.nextLineExceptComments()) {
                this.buf.clear();
                while (this.tokenizer.valid()) {
                    String string = this.tokenizer.getSubstring();
                    int n = this.keymap.get((Object)string);
                    if (n < 0) {
                        n = this.keymap.size();
                        this.keymap.put((Object)string, n);
                    }
                    int n2 = n >>> 6;
                    int n3 = n & 0x3F;
                    while (n2 >= this.buf.size()) {
                        this.buf.add(0L);
                    }
                    this.buf.set(n2, this.buf.get(n2) | 1L << n3);
                    this.tokenizer.advance();
                }
                this.curvec = new BitVector(this.buf.toArray(), this.keymap.size());
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            this.nextevent = BundleStreamSource.Event.END_OF_STREAM;
            this.meta = new BundleMeta(1);
            String[] stringArray = new String[this.keymap.size()];
            TObjectIntIterator tObjectIntIterator = this.keymap.iterator();
            while (tObjectIntIterator.hasNext()) {
                tObjectIntIterator.advance();
                stringArray[tObjectIntIterator.value()] = (String)tObjectIntIterator.key();
            }
            this.meta.add(new VectorFieldTypeInformation<BitVector>(BitVector.FACTORY, stringArray.length, stringArray));
            return BundleStreamSource.Event.META_CHANGED;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.curvec = null;
    }

    @Override
    public Object data(int n) {
        if (n == 0) {
            return this.curvec;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.meta = new BundleMeta(1);
            this.meta.add(new VectorTypeInformation<BitVector>(BitVector.FACTORY, BitVector.SHORT_SERIALIZER, 0, this.numterms));
        }
        return this.meta;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected SimpleTransactionParser makeInstance() {
            return new SimpleTransactionParser(this.format);
        }
    }
}

