/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.geo;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.NoDuplicateValueGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class DimensionSelectingLatLngDistanceFunction
extends AbstractSpatialDistanceFunction {
    final int dimlat;
    final int dimlng;
    final EarthModel model;

    public DimensionSelectingLatLngDistanceFunction(int n, int n2, EarthModel earthModel) {
        this.dimlat = n;
        this.dimlng = n2;
        this.model = earthModel;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        return this.model.distanceDeg(numberVector.doubleValue(this.dimlat), numberVector.doubleValue(this.dimlng), numberVector2.doubleValue(this.dimlat), numberVector2.doubleValue(this.dimlng));
    }

    @Override
    @Reference(authors="Erich Schubert, Arthur Zimek and Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Advances in Spatial and Temporal Databases - 13th International Symposium, SSTD 2013, Munich, Germany")
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable instanceof NumberVector) {
            if (spatialComparable2 instanceof NumberVector) {
                return this.distance((NumberVector)spatialComparable, (NumberVector)spatialComparable2);
            }
            NumberVector numberVector = (NumberVector)spatialComparable;
            return this.model.minDistDeg(numberVector.doubleValue(this.dimlat), numberVector.doubleValue(this.dimlng), spatialComparable2.getMin(this.dimlat), spatialComparable2.getMin(this.dimlng), spatialComparable2.getMax(this.dimlat), spatialComparable2.getMax(this.dimlng));
        }
        if (spatialComparable2 instanceof NumberVector) {
            NumberVector numberVector = (NumberVector)spatialComparable2;
            return this.model.minDistDeg(numberVector.doubleValue(this.dimlat), numberVector.doubleValue(this.dimlng), spatialComparable.getMin(this.dimlat), spatialComparable.getMin(this.dimlng), spatialComparable.getMax(this.dimlat), spatialComparable.getMax(this.dimlng));
        }
        throw new NotImplementedException("This distance function cannot - yet - be used with this algorithm, as the lower bound rectangle to rectangle distances have not yet been formalized for geodetic data.");
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, Math.max(this.dimlat, this.dimlng), Integer.MAX_VALUE);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.dimlat;
        n = 31 * n + this.dimlng;
        n = 31 * n + (this.model == null ? 0 : this.model.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DimensionSelectingLatLngDistanceFunction dimensionSelectingLatLngDistanceFunction = (DimensionSelectingLatLngDistanceFunction)object;
        if (this.dimlat != dimensionSelectingLatLngDistanceFunction.dimlat) {
            return false;
        }
        if (this.dimlng != dimensionSelectingLatLngDistanceFunction.dimlng) {
            return false;
        }
        return !(this.model == null ? dimensionSelectingLatLngDistanceFunction.model != null : !this.model.equals(dimensionSelectingLatLngDistanceFunction.model));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID LATDIM_ID = new OptionID("distance.latitudedim", "The dimension containing the latitude.");
        public static final OptionID LNGDIM_ID = new OptionID("distance.longitudedim", "The dimension containing the longitude.");
        int dimlat;
        int dimlng;
        EarthModel model;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(LATDIM_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.dimlat = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(LNGDIM_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter2)) {
                this.dimlng = (Integer)intParameter2.getValue();
            }
            parameterization.checkConstraint(new NoDuplicateValueGlobalConstraint(intParameter, intParameter2));
            ObjectParameter objectParameter = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (parameterization.grab(objectParameter)) {
                this.model = (EarthModel)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected DimensionSelectingLatLngDistanceFunction makeInstance() {
            return new DimensionSelectingLatLngDistanceFunction(this.dimlat, this.dimlng, this.model);
        }
    }
}

