/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.SparseMaximumDistanceFunction"})
public class SparseMaximumDistanceFunction
extends SparseLPNormDistanceFunction {
    public static final SparseMaximumDistanceFunction STATIC = new SparseMaximumDistanceFunction();

    @Deprecated
    public SparseMaximumDistanceFunction() {
        super(Double.POSITIVE_INFINITY);
    }

    @Override
    public double distance(SparseNumberVector sparseNumberVector, SparseNumberVector sparseNumberVector2) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        int n2 = sparseNumberVector2.iter();
        while (sparseNumberVector.iterValid(n) && sparseNumberVector2.iterValid(n2)) {
            double d2;
            int n3;
            int n4 = sparseNumberVector.iterDim(n);
            if (n4 < (n3 = sparseNumberVector2.iterDim(n2))) {
                d2 = Math.abs(sparseNumberVector.iterDoubleValue(n));
                if (d2 > d) {
                    d = d2;
                }
                n = sparseNumberVector.iterAdvance(n);
                continue;
            }
            if (n3 < n4) {
                d2 = Math.abs(sparseNumberVector2.iterDoubleValue(n2));
                if (d2 > d) {
                    d = d2;
                }
                n2 = sparseNumberVector2.iterAdvance(n2);
                continue;
            }
            d2 = Math.abs(sparseNumberVector.iterDoubleValue(n) - sparseNumberVector2.iterDoubleValue(n2));
            if (d2 > d) {
                d = d2;
            }
            n = sparseNumberVector.iterAdvance(n);
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        while (sparseNumberVector.iterValid(n)) {
            double d3 = Math.abs(sparseNumberVector.iterDoubleValue(n));
            if (d3 > d) {
                d = d3;
            }
            n = sparseNumberVector.iterAdvance(n);
        }
        while (sparseNumberVector2.iterValid(n2)) {
            double d4 = Math.abs(sparseNumberVector2.iterDoubleValue(n2));
            if (d4 > d) {
                d = d4;
            }
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        return d;
    }

    @Override
    public double norm(SparseNumberVector sparseNumberVector) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        while (sparseNumberVector.iterValid(n)) {
            double d2 = Math.abs(sparseNumberVector.iterDoubleValue(n));
            if (d2 > d) {
                d = d2;
            }
            n = sparseNumberVector.iterAdvance(n);
        }
        return d;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SparseMaximumDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

