/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractIndexBasedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

public class FractionalSharedNearestNeighborSimilarityFunction<O>
extends AbstractIndexBasedSimilarityFunction<O, SharedNearestNeighborIndex<O>>
implements NormalizedSimilarityFunction<O> {
    public FractionalSharedNearestNeighborSimilarityFunction(SharedNearestNeighborIndex.Factory<O, SharedNearestNeighborIndex<O>> factory) {
        super(factory);
    }

    @Override
    public <T extends O> Instance<T> instantiate(Relation<T> relation) {
        SharedNearestNeighborIndex sharedNearestNeighborIndex = (SharedNearestNeighborIndex)this.indexFactory.instantiate(relation);
        return new Instance<T>(relation, sharedNearestNeighborIndex, this);
    }

    public static class Parameterizer<O>
    extends AbstractIndexBasedSimilarityFunction.Parameterizer<SharedNearestNeighborIndex.Factory<O, SharedNearestNeighborIndex<O>>> {
        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.configIndexFactory(parameterization, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        @Override
        protected FractionalSharedNearestNeighborSimilarityFunction<O> makeInstance() {
            return new FractionalSharedNearestNeighborSimilarityFunction((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<T>
    extends AbstractIndexBasedSimilarityFunction.Instance<T, SharedNearestNeighborIndex<T>> {
        private FractionalSharedNearestNeighborSimilarityFunction<? super T> similarityFunction;

        public Instance(Relation<T> relation, SharedNearestNeighborIndex<T> sharedNearestNeighborIndex, FractionalSharedNearestNeighborSimilarityFunction<? super T> fractionalSharedNearestNeighborSimilarityFunction) {
            super(relation, sharedNearestNeighborIndex);
            this.similarityFunction = fractionalSharedNearestNeighborSimilarityFunction;
        }

        protected static int countSharedNeighbors(DBIDs dBIDs, DBIDs dBIDs2) {
            int n = 0;
            DBIDIter dBIDIter = dBIDs.iter();
            DBIDIter dBIDIter2 = dBIDs2.iter();
            while (dBIDIter.valid() && dBIDIter2.valid()) {
                int n2 = DBIDUtil.compare(dBIDIter, dBIDIter2);
                if (n2 == 0) {
                    ++n;
                    dBIDIter.advance();
                    dBIDIter2.advance();
                    continue;
                }
                if (n2 < 0) {
                    dBIDIter.advance();
                    continue;
                }
                dBIDIter2.advance();
            }
            return n;
        }

        @Override
        public double similarity(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            ArrayDBIDs arrayDBIDs = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(dBIDRef);
            ArrayDBIDs arrayDBIDs2 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(dBIDRef2);
            int n = Instance.countSharedNeighbors(arrayDBIDs, arrayDBIDs2);
            return (double)n / (double)((SharedNearestNeighborIndex)this.index).getNumberOfNeighbors();
        }

        @Override
        public SimilarityFunction<? super T> getSimilarityFunction() {
            return this.similarityFunction;
        }
    }
}

