/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractPrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster.ClusteringDistanceSimilarityFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Fowlkes, E.B. and Mallows, C.L.", title="A method for comparing two hierarchical clusterings", booktitle="Journal of the American Statistical Association, Vol. 78 Issue 383")
public class ClusteringFowlkesMallowsSimilarityFunction
extends AbstractPrimitiveSimilarityFunction<Clustering<?>>
implements ClusteringDistanceSimilarityFunction,
NormalizedSimilarityFunction<Clustering<?>> {
    public static final ClusteringFowlkesMallowsSimilarityFunction STATIC = new ClusteringFowlkesMallowsSimilarityFunction();

    @Override
    public double similarity(Clustering<?> clustering, Clustering<?> clustering2) {
        ClusterContingencyTable clusterContingencyTable = new ClusterContingencyTable(false, true);
        clusterContingencyTable.process(clustering, clustering2);
        return clusterContingencyTable.getPaircount().fowlkesMallows();
    }

    @Override
    public double distance(Clustering<?> clustering, Clustering<?> clustering2) {
        ClusterContingencyTable clusterContingencyTable = new ClusterContingencyTable(false, true);
        clusterContingencyTable.process(clustering, clustering2);
        return 1.0 - clusterContingencyTable.getPaircount().fowlkesMallows();
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation<Clustering>(Clustering.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClusteringFowlkesMallowsSimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

