/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import java.util.logging.Level;

public class KernelMatrix {
    Matrix kernel;
    DBIDMap idmap;

    public <O> KernelMatrix(PrimitiveSimilarityFunction<? super O> primitiveSimilarityFunction, Relation<? extends O> relation, DBIDs dBIDs) {
        this.kernel = new Matrix(dBIDs.size(), dBIDs.size());
        this.idmap = dBIDs instanceof DBIDRange ? new RangeMap((DBIDRange)dBIDs) : new SortedArrayMap(dBIDs);
        DBIDArrayIter dBIDArrayIter = this.idmap.iter();
        DBIDArrayIter dBIDArrayIter2 = this.idmap.iter();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.valid()) {
            O o = relation.get(dBIDArrayIter);
            dBIDArrayIter2.seek(dBIDArrayIter.getOffset());
            while (dBIDArrayIter2.valid()) {
                double d = primitiveSimilarityFunction.similarity(o, relation.get(dBIDArrayIter2));
                this.kernel.set(dBIDArrayIter.getOffset(), dBIDArrayIter2.getOffset(), d);
                this.kernel.set(dBIDArrayIter2.getOffset(), dBIDArrayIter.getOffset(), d);
                dBIDArrayIter2.advance();
            }
            dBIDArrayIter.advance();
        }
    }

    public <O> KernelMatrix(SimilarityQuery<? super O> similarityQuery, Relation<? extends O> relation, DBIDs dBIDs) {
        LoggingUtil.logExpensive(Level.FINER, "Computing kernel matrix");
        this.kernel = new Matrix(dBIDs.size(), dBIDs.size());
        this.idmap = dBIDs instanceof DBIDRange ? new RangeMap((DBIDRange)dBIDs) : new SortedArrayMap(dBIDs);
        DBIDArrayIter dBIDArrayIter = this.idmap.iter();
        DBIDArrayIter dBIDArrayIter2 = this.idmap.iter();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.valid()) {
            O o = relation.get(dBIDArrayIter);
            dBIDArrayIter2.seek(dBIDArrayIter.getOffset());
            while (dBIDArrayIter2.valid()) {
                double d = similarityQuery.similarity((DBIDArrayIter)o, dBIDArrayIter2);
                this.kernel.set(dBIDArrayIter.getOffset(), dBIDArrayIter2.getOffset(), d);
                this.kernel.set(dBIDArrayIter2.getOffset(), dBIDArrayIter.getOffset(), d);
                dBIDArrayIter2.advance();
            }
            dBIDArrayIter.advance();
        }
    }

    public KernelMatrix(Matrix matrix) {
        this.kernel = matrix.copy();
    }

    public double getDistance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return Math.sqrt(this.getSquaredDistance(dBIDRef, dBIDRef2));
    }

    public Matrix getKernel() {
        return this.kernel;
    }

    public double getSquaredDistance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        int n = this.idmap.getOffset(dBIDRef);
        int n2 = this.idmap.getOffset(dBIDRef2);
        return this.kernel.get(n, n) + this.kernel.get(n2, n2) - 2.0 * this.kernel.get(n, n2);
    }

    @Deprecated
    public Matrix getSubColumn(DBIDRef dBIDRef, DBIDs dBIDs) {
        int[] nArray = new int[]{this.idmap.getOffset(dBIDRef)};
        int[] nArray2 = new int[dBIDs.size()];
        int n = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            nArray2[n] = this.idmap.getOffset(dBIDIter);
            dBIDIter.advance();
            ++n;
        }
        return this.kernel.getMatrix(nArray2, nArray);
    }

    public Matrix getSubMatrix(DBIDs dBIDs) {
        int[] nArray = new int[dBIDs.size()];
        int n = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            nArray[n] = this.idmap.getOffset(dBIDIter);
            dBIDIter.advance();
            ++n;
        }
        return this.kernel.getMatrix(nArray, nArray);
    }

    public static Matrix centerMatrix(Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix.getRowDimensionality(), matrix.getColumnDimensionality(), 1.0 / (double)matrix.getColumnDimensionality());
        return matrix.minusEquals(matrix2.times(matrix)).minusEquals(matrix.times(matrix2)).plusEquals(matrix2.times(matrix).times(matrix2));
    }

    public String toString() {
        return super.toString();
    }

    public static Matrix centerKernelMatrix(KernelMatrix kernelMatrix) {
        return KernelMatrix.centerMatrix(kernelMatrix.getKernel());
    }

    public double getSimilarity(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return this.kernel.get(this.idmap.getOffset(dBIDRef), this.idmap.getOffset(dBIDRef2));
    }

    private static class SortedArrayMap
    implements DBIDMap {
        ArrayModifiableDBIDs ids;

        public SortedArrayMap(DBIDs dBIDs) {
            this.ids = DBIDUtil.newArray(dBIDs);
            this.ids.sort();
        }

        @Override
        public int getOffset(DBIDRef dBIDRef) {
            return this.ids.binarySearch(dBIDRef);
        }

        @Override
        public DBIDArrayIter iter() {
            return this.ids.iter();
        }
    }

    private static class RangeMap
    implements DBIDMap {
        DBIDRange range;

        public RangeMap(DBIDRange dBIDRange) {
            this.range = dBIDRange;
        }

        @Override
        public int getOffset(DBIDRef dBIDRef) {
            return this.range.getOffset(dBIDRef);
        }

        @Override
        public DBIDArrayIter iter() {
            return this.range.iter();
        }
    }

    private static interface DBIDMap {
        public int getOffset(DBIDRef var1);

        public DBIDArrayIter iter();
    }
}

