/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Alias(value={"sigmoid"})
public class SigmoidKernelFunction
extends AbstractVectorSimilarityFunction {
    private final double c;
    private final double theta;

    public SigmoidKernelFunction(double d, double d2) {
        this.c = d;
        this.theta = d2;
    }

    @Override
    public double similarity(NumberVector numberVector, NumberVector numberVector2) {
        int n = AbstractNumberVectorDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i) * numberVector2.doubleValue(i);
            d += d2;
        }
        return Math.tanh(this.c * d + this.theta);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID C_ID = new OptionID("kernel.sigmoid.c", "Sigmoid c parameter (scaling).");
        public static final OptionID THETA_ID = new OptionID("kernel.sigmoid.theta", "Sigmoid theta parameter (bias).");
        protected double c = 1.0;
        protected double theta = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(C_ID, 1.0);
            if (parameterization.grab(doubleParameter2)) {
                this.c = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(THETA_ID, 0.0))) {
                this.theta = doubleParameter.doubleValue();
            }
        }

        @Override
        protected SigmoidKernelFunction makeInstance() {
            return new SigmoidKernelFunction(this.c, this.theta);
        }
    }
}

