/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.extractor;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.HDBSCANHierarchyExtraction;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.extractor.ExtractFlatClusteringFromHierarchyEvaluator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;

public class HDBSCANHierarchyExtractionEvaluator
implements Evaluator {
    private HDBSCANHierarchyExtraction inner;

    public HDBSCANHierarchyExtractionEvaluator(HDBSCANHierarchyExtraction hDBSCANHierarchyExtraction) {
        this.inner = hDBSCANHierarchyExtraction;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<PointerHierarchyRepresentationResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, PointerHierarchyRepresentationResult.class);
        for (PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult : arrayList) {
            DBIDs dBIDs = pointerHierarchyRepresentationResult.getDBIDs();
            DBIDDataStore dBIDDataStore = pointerHierarchyRepresentationResult.getParentStore();
            DoubleDataStore doubleDataStore = pointerHierarchyRepresentationResult.getParentDistanceStore();
            DoubleDataStore doubleDataStore2 = null;
            if (pointerHierarchyRepresentationResult instanceof PointerDensityHierarchyRepresentationResult) {
                doubleDataStore2 = ((PointerDensityHierarchyRepresentationResult)pointerHierarchyRepresentationResult).getCoreDistanceStore();
            }
            Clustering<DendrogramModel> clustering = this.inner.extractClusters(dBIDs, dBIDDataStore, doubleDataStore, doubleDataStore2);
            pointerHierarchyRepresentationResult.addChildResult(clustering);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        HDBSCANHierarchyExtraction inner;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, ExtractFlatClusteringFromHierarchyEvaluator.DummyHierarchicalClusteringAlgorithm.class);
            ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
            this.inner = (HDBSCANHierarchyExtraction)ClassGenericsUtil.parameterizeOrAbort(HDBSCANHierarchyExtraction.class, chainedParameterization);
        }

        @Override
        protected HDBSCANHierarchyExtractionEvaluator makeInstance() {
            return new HDBSCANHierarchyExtractionEvaluator(this.inner);
        }
    }
}

