/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segment;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

@Reference(title="Evaluation of Clusterings \u2013 Metrics and Visual Support", authors="Elke Achtert, Sascha Goldhofer, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", booktitle="Proc. 28th International Conference on Data Engineering (ICDE) 2012", url="http://dx.doi.org/10.1109/ICDE.2012.128")
public class Segments
extends BasicResult
implements Iterable<Segment> {
    private static final Logging LOG = Logging.getLogger(Segments.class);
    private List<Clustering<?>> clusterings;
    private List<List<? extends Cluster<?>>> clusters;
    private int clusteringsCount;
    private int[] numclusters;
    private int totalObjects;
    private int actualPairs;
    private TreeMap<Segment, Segment> segments;

    public Segments(List<Clustering<?>> list) {
        super("cluster pair segments", "pair-segments");
        this.clusterings = list;
        this.clusteringsCount = list.size();
        this.segments = new TreeMap();
        this.numclusters = new int[this.clusteringsCount];
        this.clusters = new ArrayList(this.clusteringsCount);
        int n = 0;
        for (Clustering<?> object : list) {
            List<Cluster<?>> list2 = object.getAllClusters();
            this.clusters.add(list2);
            this.numclusters[n] = list2.size();
            ++n;
        }
        this.recursivelyFill(this.clusters);
        for (Segment segment : this.segments.keySet()) {
            this.actualPairs = (int)((long)this.actualPairs + segment.getPairCount());
        }
    }

    private void recursivelyFill(List<List<? extends Cluster<?>>> list) {
        int n = list.size();
        Iterator<Cluster<?>> iterator = list.get(0).iterator();
        int[] nArray = new int[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Cluster<?> cluster = iterator.next();
            nArray[0] = n2;
            if (n > 1) {
                SetDBIDs setDBIDs = DBIDUtil.ensureSet(cluster.getIDs());
                this.recursivelyFill(list, 1, setDBIDs, setDBIDs, nArray, true);
            } else {
                this.makeOrUpdateSegment(nArray, cluster.getIDs(), cluster.size() * (cluster.size() - 1));
            }
            this.totalObjects += cluster.size();
            ++n2;
        }
    }

    private void recursivelyFill(List<List<? extends Cluster<?>>> list, int n, SetDBIDs setDBIDs, SetDBIDs setDBIDs2, int[] nArray, boolean bl) {
        int n2 = list.size();
        Iterator<Cluster<?>> iterator = list.get(n).iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Cluster<?> cluster = iterator.next();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(setDBIDs.size());
            HashSetModifiableDBIDs hashSetModifiableDBIDs2 = DBIDUtil.newHashSet(setDBIDs);
            HashSetModifiableDBIDs hashSetModifiableDBIDs3 = DBIDUtil.newHashSet();
            HashSetModifiableDBIDs hashSetModifiableDBIDs4 = DBIDUtil.newHashSet(setDBIDs2.size());
            Object object = cluster.getIDs().iter();
            while (object.valid()) {
                if (hashSetModifiableDBIDs2.remove((DBIDRef)object)) {
                    hashSetModifiableDBIDs.add((DBIDRef)object);
                } else {
                    hashSetModifiableDBIDs3.add((DBIDRef)object);
                }
                if (setDBIDs2.contains((DBIDRef)object)) {
                    hashSetModifiableDBIDs4.add((DBIDRef)object);
                }
                object.advance();
            }
            if (hashSetModifiableDBIDs4.size() > 0) {
                if (hashSetModifiableDBIDs.size() > 0) {
                    nArray[n] = n3;
                    if (n < n2 - 1) {
                        this.recursivelyFill(list, n + 1, hashSetModifiableDBIDs, hashSetModifiableDBIDs4, nArray, bl);
                    } else {
                        int n4 = DBIDUtil.intersectionSize(hashSetModifiableDBIDs, hashSetModifiableDBIDs4);
                        if (bl) {
                            this.makeOrUpdateSegment(nArray, hashSetModifiableDBIDs, hashSetModifiableDBIDs.size() * hashSetModifiableDBIDs4.size() - n4);
                        } else {
                            this.makeOrUpdateSegment(nArray, null, hashSetModifiableDBIDs.size() * hashSetModifiableDBIDs4.size() - n4);
                        }
                    }
                }
                if (hashSetModifiableDBIDs2.size() > 0) {
                    nArray[n] = -1;
                    if (n < n2 - 1) {
                        this.recursivelyFill(list, n + 1, hashSetModifiableDBIDs2, hashSetModifiableDBIDs4, nArray, false);
                    } else {
                        int n5 = DBIDUtil.intersection(hashSetModifiableDBIDs2, hashSetModifiableDBIDs4).size();
                        this.makeOrUpdateSegment(nArray, null, hashSetModifiableDBIDs2.size() * hashSetModifiableDBIDs4.size() - n5);
                    }
                }
                if (hashSetModifiableDBIDs3.size() > 0 && bl) {
                    object = new int[nArray.length];
                    Arrays.fill((int[])object, -1);
                    object[n] = n3;
                    if (n < n2 - 1) {
                        this.recursivelyFill(list, n + 1, hashSetModifiableDBIDs3, hashSetModifiableDBIDs4, (int[])object, false);
                    } else {
                        int n6 = DBIDUtil.intersection(hashSetModifiableDBIDs3, hashSetModifiableDBIDs4).size();
                        this.makeOrUpdateSegment((int[])object, null, hashSetModifiableDBIDs3.size() * hashSetModifiableDBIDs4.size() - n6);
                    }
                }
            }
            ++n3;
        }
    }

    private void makeOrUpdateSegment(int[] nArray, DBIDs dBIDs, int n) {
        Segment segment = this.segments.get(new Segment(nArray));
        if (segment == null) {
            segment = new Segment((int[])nArray.clone());
            this.segments.put(segment, segment);
        }
        if (dBIDs != null) {
            if (segment.getDBIDs() != null) {
                LOG.warning("Expected segment to not have IDs.");
            }
            segment.objIDs = dBIDs;
        }
        segment.pairsize += (long)n;
    }

    public String getClusteringDescription(int n) {
        return this.clusterings.get(n).getLongName();
    }

    public List<Segment> getPairedSegments(Segment segment) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        block0: for (Segment segment2 : this) {
            for (int i = 0; i < this.clusteringsCount; ++i) {
                if (segment.get(i) != -1 && segment2.get(i) != segment.get(i) || segment2.get(i) == -1) continue block0;
            }
            arrayList.add(segment2);
        }
        return arrayList;
    }

    public Segment unifySegment(Segment segment) {
        Segment segment2 = this.segments.get(segment);
        return segment2 != null ? segment2 : segment;
    }

    public int size() {
        return this.segments.size();
    }

    public int getPairCount(boolean bl) {
        if (bl) {
            return this.totalObjects * (this.totalObjects - 1);
        }
        return this.actualPairs;
    }

    public int getClusterings() {
        return this.clusteringsCount;
    }

    public int getTotalClusterCount() {
        int n = 0;
        for (int i = 0; i < this.numclusters.length; ++i) {
            n += this.numclusters[i];
        }
        return n;
    }

    public int getHighestClusterCount() {
        int n = 0;
        for (int i = 0; i < this.numclusters.length; ++i) {
            n = Math.max(n, this.numclusters[i]);
        }
        return n;
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.keySet().iterator();
    }
}

