/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.minigui;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.application.KDDCLIApplication;
import de.lmu.ifi.dbs.elki.gui.GUIUtil;
import de.lmu.ifi.dbs.elki.gui.util.DynamicParameters;
import de.lmu.ifi.dbs.elki.gui.util.LogPanel;
import de.lmu.ifi.dbs.elki.gui.util.ParameterTable;
import de.lmu.ifi.dbs.elki.gui.util.ParametersModel;
import de.lmu.ifi.dbs.elki.gui.util.SavedSettingsFile;
import de.lmu.ifi.dbs.elki.logging.CLISmartHandler;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.workflow.LoggingStep;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

@Alias(value={"mini", "minigui"})
public class MiniGUI
extends AbstractApplication {
    public static final String SAVED_SETTINGS_FILENAME = "MiniGUI-saved-settings.txt";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Logging LOG = Logging.getLogger(MiniGUI.class);
    protected static final String ACTION_QUIT = "quit";
    JFrame frame;
    JPanel panel;
    protected LogPanel outputArea;
    protected ParameterTable parameterTable;
    protected DynamicParameters parameters;
    protected SavedSettingsFile store = new SavedSettingsFile("MiniGUI-saved-settings.txt");
    protected JComboBox<String> appCombo;
    protected JComboBox<String> savedCombo;
    protected SettingsComboboxModel savedSettingsModel;
    protected JButton runButton;
    private Class<? extends AbstractApplication> maincls = KDDCLIApplication.class;
    private JTextField commandLine;
    private String APP_PREFIX = AbstractApplication.class.getPackage().getName() + ".";

    public MiniGUI() {
        this.frame = new JFrame("ELKI MiniGUI Command Line Builder");
        this.frame.setDefaultCloseOperation(2);
        try {
            this.frame.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panel = new JPanel();
        this.panel.setOpaque(true);
        this.panel.setLayout(new GridBagLayout());
        this.setupAppChooser();
        this.setupParameterTable();
        this.setupLoadSaveButtons();
        this.setupCommandLine();
        this.setupLoggingArea();
        try {
            this.store.load();
            this.savedSettingsModel.update();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(81, 2);
        this.panel.getInputMap().put(keyStroke, ACTION_QUIT);
        keyStroke = KeyStroke.getKeyStroke(87, 2);
        this.panel.getInputMap().put(keyStroke, ACTION_QUIT);
        this.panel.getActionMap().put(ACTION_QUIT, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiniGUI.this.frame.dispose();
            }
        });
        this.frame.setContentPane(this.panel);
        this.frame.pack();
    }

    private void setupAppChooser() {
        Serializable serializable2;
        this.appCombo = new JComboBox();
        for (Serializable serializable2 : ELKIServiceRegistry.findAllImplementations(AbstractApplication.class)) {
            String string = serializable2.getCanonicalName();
            if (string == null || serializable2.getCanonicalName().contains("GUI")) continue;
            if (string.startsWith(this.APP_PREFIX)) {
                string = string.substring(this.APP_PREFIX.length());
            }
            this.appCombo.addItem(string);
        }
        this.appCombo.setEditable(true);
        Object object = this.maincls.getCanonicalName();
        if (((String)object).startsWith(this.APP_PREFIX)) {
            object = ((String)object).substring(this.APP_PREFIX.length());
        }
        this.appCombo.setSelectedItem(object);
        this.appCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
                    Class<AbstractApplication> clazz = ELKIServiceRegistry.findImplementation(AbstractApplication.class, (String)MiniGUI.this.appCombo.getSelectedItem());
                    if (clazz != null) {
                        MiniGUI.this.maincls = clazz;
                        MiniGUI.this.updateParameterTable();
                    } else {
                        LOG.warning("Main class name not found.");
                    }
                }
            }
        });
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 0;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 0.01;
        this.panel.add(this.appCombo, serializable2);
    }

    private void setupParameterTable() {
        this.parameters = new DynamicParameters();
        ParametersModel parametersModel = new ParametersModel(this.parameters);
        parametersModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                MiniGUI.this.updateParameterTable();
            }
        });
        this.parameterTable = new ParameterTable(this.frame, parametersModel, this.parameters);
        JScrollPane jScrollPane = new JScrollPane(this.parameterTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)jScrollPane, gridBagConstraints);
    }

    private void setupLoadSaveButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.savedSettingsModel = new SettingsComboboxModel(this.store);
        this.savedCombo = new JComboBox<String>(this.savedSettingsModel);
        this.savedCombo.setEditable(true);
        this.savedCombo.setSelectedItem("[Saved Settings]");
        jPanel.add(this.savedCombo);
        JButton jButton = new JButton("Load");
        jButton.setMnemonic(76);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MiniGUI.this.savedSettingsModel.getSelectedItem();
                ArrayList<String> arrayList = MiniGUI.this.store.get(string);
                if (arrayList != null) {
                    MiniGUI.this.doSetParameters(arrayList);
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Save");
        jButton2.setMnemonic(83);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MiniGUI.this.savedSettingsModel.getSelectedItem();
                MiniGUI.this.parameterTable.editCellAt(-1, -1);
                ArrayList<String> arrayList = new ArrayList<String>(MiniGUI.this.parameters.size() * 2 + 1);
                arrayList.add(MiniGUI.this.maincls.getCanonicalName());
                MiniGUI.this.parameters.serializeParameters(arrayList);
                MiniGUI.this.store.put(string, arrayList);
                try {
                    MiniGUI.this.store.save();
                }
                catch (IOException iOException) {
                    LOG.exception(iOException);
                }
                MiniGUI.this.savedSettingsModel.update();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Remove");
        jButton3.setMnemonic(69);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MiniGUI.this.savedSettingsModel.getSelectedItem();
                MiniGUI.this.store.remove(string);
                try {
                    MiniGUI.this.store.save();
                }
                catch (IOException iOException) {
                    LOG.exception(iOException);
                }
                MiniGUI.this.savedCombo.setSelectedItem("[Saved Settings]");
                MiniGUI.this.savedSettingsModel.update();
            }
        });
        jPanel.add(jButton3);
        this.runButton = new JButton("Run Task");
        this.runButton.setMnemonic(82);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiniGUI.this.startTask();
            }
        });
        jPanel.add(this.runButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        this.panel.add((Component)jPanel, gridBagConstraints);
    }

    private void setupCommandLine() {
        this.commandLine = new JTextField();
        this.commandLine.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        this.panel.add((Component)this.commandLine, gridBagConstraints);
    }

    private void setupLoggingArea() {
        this.outputArea = new LogPanel();
        JScrollPane jScrollPane = new JScrollPane(this.outputArea);
        jScrollPane.setPreferredSize(new Dimension(800, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)jScrollPane, gridBagConstraints);
    }

    protected void updateParameterTable() {
        this.parameterTable.setEnabled(false);
        ArrayList<String> arrayList = new ArrayList<String>(this.parameters.size() * 2 + 1);
        arrayList.add(this.maincls.getCanonicalName());
        this.parameters.serializeParameters(arrayList);
        this.doSetParameters(arrayList);
        this.parameterTable.setEnabled(true);
    }

    protected void doSetParameters(List<String> list) {
        boolean bl;
        Object object;
        Object object2;
        if (list.size() > 0 && !((String)(object2 = list.get(0))).startsWith("-") && (object = ELKIServiceRegistry.findImplementation(AbstractApplication.class, (String)object2)) != null) {
            this.maincls = object;
            list.remove(0);
        }
        object2 = new SerializedParameterization(list);
        object = new TrackParameters((Parameterization)object2);
        ((TrackParameters)object).tryInstantiate(LoggingStep.class);
        ((TrackParameters)object).tryInstantiate(this.maincls);
        ((SerializedParameterization)object2).logUnusedParameters();
        boolean bl2 = bl = ((AbstractParameterization)object2).getErrors().size() > 0;
        if (bl && list.size() > 0) {
            this.reportErrors((SerializedParameterization)object2);
        }
        this.runButton.setEnabled(!bl);
        List<String> list2 = ((SerializedParameterization)object2).getRemainingParameters();
        this.outputArea.clear();
        String string = this.maincls.getCanonicalName();
        if (string.startsWith(this.APP_PREFIX)) {
            string = string.substring(this.APP_PREFIX.length());
        }
        this.commandLine.setText(this.format(string, list));
        this.parameterTable.removeEditor();
        this.parameterTable.setEnabled(false);
        this.parameters.updateFromTrackParameters((TrackParameters)object);
        if (list2 != null && !list2.isEmpty()) {
            DynamicParameters.RemainingOptions remainingOptions = new DynamicParameters.RemainingOptions();
            try {
                remainingOptions.setValue(FormatUtil.format(list2, " "));
            }
            catch (ParameterException parameterException) {
                LOG.exception(parameterException);
            }
            int n = 6;
            this.parameters.addParameter(remainingOptions, (String)remainingOptions.getValue(), n, 0);
        }
        ((AbstractParameterization)object2).clearErrors();
        this.parameterTable.revalidate();
        this.parameterTable.setEnabled(true);
    }

    private String format(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            if (object instanceof String) {
                this.formatTo(stringBuilder, (String)object);
                continue;
            }
            if (object instanceof List) {
                this.formatTo(stringBuilder, (List)object);
                continue;
            }
            LOG.warning("Incorrect object type: " + object.getClass());
        }
        return stringBuilder.toString();
    }

    private void formatTo(StringBuilder stringBuilder, List<?> list) {
        for (Object obj : list) {
            if (obj instanceof String) {
                this.formatTo(stringBuilder, (String)obj);
                continue;
            }
            LOG.warning("Incorrect object type: " + obj.getClass());
        }
    }

    private void formatTo(StringBuilder stringBuilder, String string) {
        char c;
        int n;
        if (string == null || string.length() == 0) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            c = string.charAt(n);
            if (c == '\\') {
                n2 |= 8;
                continue;
            }
            if (c <= ' ' || c >= '\u0080' || c == '<' || c == '>' || c == '|' || c == '$') {
                n2 |= 1;
                continue;
            }
            if (c == '\"') {
                n2 |= 2;
                continue;
            }
            if (c != '\'') continue;
            n2 |= 4;
        }
        if (n2 == 0) {
            stringBuilder.append(string);
        } else if ((n2 & 0xA) == 0) {
            stringBuilder.append('\"').append(string).append('\"');
        } else if ((n2 & 0xC) == 0) {
            stringBuilder.append('\'').append(string).append('\'');
        } else {
            stringBuilder.append('\"');
            n3 = string.length();
            for (n = 0; n < n3; ++n) {
                c = string.charAt(n);
                if (c == '\"' || c == '\\' || c == '$') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\"');
        }
    }

    protected void loadLatest() {
        int n = this.store.size();
        if (n > 0) {
            Pair<String, ArrayList<String>> pair = this.store.getElementAt(n - 1);
            this.savedSettingsModel.setSelectedItem(pair.first);
            this.doSetParameters((List)pair.second);
        }
    }

    protected void startTask() {
        this.parameterTable.editCellAt(-1, -1);
        this.parameterTable.setEnabled(false);
        final ArrayList<String> arrayList = new ArrayList<String>(this.parameters.size() * 2);
        this.parameters.serializeParameters(arrayList);
        this.parameterTable.setEnabled(true);
        this.runButton.setEnabled(false);
        this.outputArea.clear();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                SerializedParameterization serializedParameterization = new SerializedParameterization(arrayList);
                serializedParameterization.tryInstantiate(LoggingStep.class);
                AbstractApplication abstractApplication = (AbstractApplication)serializedParameterization.tryInstantiate(MiniGUI.this.maincls);
                try {
                    serializedParameterization.logUnusedParameters();
                    if (serializedParameterization.getErrors().size() == 0) {
                        abstractApplication.run();
                    } else {
                        MiniGUI.this.reportErrors(serializedParameterization);
                    }
                    LOG.debug("Task completed successfully.");
                }
                catch (Throwable throwable) {
                    LOG.exception("Task failed", throwable);
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                MiniGUI.this.runButton.setEnabled(true);
            }
        };
        swingWorker.execute();
    }

    protected void reportErrors(SerializedParameterization serializedParameterization) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Task is not completely configured:" + NEWLINE + NEWLINE);
        for (ParameterException parameterException : serializedParameterization.getErrors()) {
            if (parameterException instanceof UnspecifiedParameterException) {
                stringBuilder.append("The parameter ");
                stringBuilder.append(((UnspecifiedParameterException)parameterException).getParameterName());
                stringBuilder.append(" is required.").append(NEWLINE);
                continue;
            }
            stringBuilder.append(parameterException.getMessage() + NEWLINE);
        }
        LOG.warning(stringBuilder.toString());
        serializedParameterization.clearErrors();
    }

    @Override
    public void run() throws UnableToComplyException {
        this.frame.setVisible(true);
        this.outputArea.becomeDefaultLogger();
    }

    public static void main(final String[] stringArray) {
        Object object;
        try {
            object = ClassLoader.getSystemClassLoader().loadClass("de.lmu.ifi.dbs.elki.database.ids.DBIDUtil");
            ((Class)object).getMethod("newHashSet", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Your Java class path is incomplete.\n");
            if (reflectiveOperationException.getCause() != null) {
                stringBuilder.append(reflectiveOperationException.getCause().toString()).append("\n");
            } else {
                stringBuilder.append(reflectiveOperationException.toString()).append("\n");
            }
            stringBuilder.append("Make sure you have all the required jars on the classpath.\n");
            stringBuilder.append("On the home page, you can find a 'elki-bundle' which should include everything.");
            JOptionPane.showMessageDialog(null, stringBuilder, "ClassPath incomplete", 0);
            return;
        }
        object = System.getenv("JAVA_TOOL_OPTION");
        if (object != null && ((String)object).indexOf("jayatana") >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The Ubuntu JAyatana 'global menu support' hack is known to cause problems with many Java applications.\n");
            stringBuilder.append("Please unset JAVA_TOOL_OPTION.");
            JOptionPane.showMessageDialog(null, stringBuilder, "Incompatible with JAyatana", 0);
            return;
        }
        GUIUtil.logUncaughtExceptions(LOG);
        GUIUtil.setLookAndFeel();
        OutputStep.setDefaultHandlerVisualizer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    final MiniGUI miniGUI = new MiniGUI();
                    miniGUI.run();
                    List<String> list = Collections.emptyList();
                    if (stringArray != null && stringArray.length > 0) {
                        Class<AbstractApplication> clazz;
                        list = new ArrayList<String>(Arrays.asList(stringArray));
                        if (list.size() > 0 && (clazz = ELKIServiceRegistry.findImplementation(AbstractApplication.class, list.get(0))) != null) {
                            miniGUI.maincls = clazz;
                            list.remove(0);
                        }
                        if (list.remove("-minigui.last")) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    miniGUI.loadLatest();
                                }
                            });
                        }
                        if (list.remove("-minigui.autorun")) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    miniGUI.startTask();
                                }
                            });
                        }
                    }
                    miniGUI.doSetParameters(list);
                }
                catch (Error | Exception throwable) {
                    LoggingConfiguration.replaceDefaultHandler(new CLISmartHandler());
                    LOG.exception(throwable);
                }
            }
        });
    }

    class SettingsComboboxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = 1L;
        protected SavedSettingsFile store;
        protected String selected = null;

        public SettingsComboboxModel(SavedSettingsFile savedSettingsFile) {
            this.store = savedSettingsFile;
        }

        @Override
        public String getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object instanceof String) {
                this.selected = (String)object;
            }
        }

        @Override
        public String getElementAt(int n) {
            return (String)this.store.getElementAt((int)(this.store.size() - 1 - n)).first;
        }

        @Override
        public int getSize() {
            return this.store.size();
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() + 1);
        }
    }
}

