/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.gui.util.ClassTree;
import de.lmu.ifi.dbs.elki.gui.util.DynamicParameters;
import de.lmu.ifi.dbs.elki.gui.util.ParametersModel;
import de.lmu.ifi.dbs.elki.gui.util.TreePopup;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParameterTable
extends JTable {
    private static final long serialVersionUID = 1L;
    static final Color COLOR_INCOMPLETE = new Color(0xFFCF9F);
    static final Color COLOR_SYNTAX_ERROR = new Color(0xFFAFAF);
    static final Color COLOR_OPTIONAL = new Color(0xDFFFDF);
    static final Color COLOR_DEFAULT_VALUE = new Color(0xDFDFDF);
    protected Frame frame;
    protected DynamicParameters parameters;

    public ParameterTable(Frame frame, ParametersModel parametersModel, DynamicParameters dynamicParameters) {
        super(parametersModel);
        this.frame = frame;
        this.parameters = dynamicParameters;
        this.setPreferredScrollableViewportSize(new Dimension(800, 400));
        this.setFillsViewportHeight(true);
        ColorfulRenderer colorfulRenderer = new ColorfulRenderer();
        this.setDefaultRenderer(Parameter.class, colorfulRenderer);
        this.setDefaultRenderer(String.class, colorfulRenderer);
        AdjustingEditor adjustingEditor = new AdjustingEditor();
        this.setDefaultEditor(String.class, adjustingEditor);
        this.setAutoResizeMode(4);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(650);
        this.addKeyListener(new Handler());
        this.setRowHeight(this.getRowHeight() + 4);
    }

    private class DispatchingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JComponent component;

        public DispatchingPanel(JComponent jComponent) {
            this.component = jComponent;
            this.setRequestFocusEnabled(true);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.component.requestFocus();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            InputMap inputMap = this.component.getInputMap(n);
            ActionMap actionMap = this.component.getActionMap();
            if (inputMap != null && actionMap != null && this.isEnabled()) {
                Action action;
                Object object = inputMap.get(keyStroke);
                Action action2 = action = object == null ? null : actionMap.get(object);
                if (action != null) {
                    return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this.component, keyEvent.getModifiers());
                }
            }
            return false;
        }
    }

    private class AdjustingEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private final DropdownEditor dropdownEditor;
        private final DefaultCellEditor plaintextEditor;
        private final ClassListEditor classListEditor;
        private final FileNameEditor fileNameEditor;
        private TableCellEditor activeEditor;

        public AdjustingEditor() {
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.setEditable(true);
            this.dropdownEditor = new DropdownEditor(jComboBox);
            JTextField jTextField = new JTextField();
            jTextField.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.plaintextEditor = new DefaultCellEditor(jTextField);
            this.classListEditor = new ClassListEditor();
            this.fileNameEditor = new FileNameEditor();
        }

        @Override
        public Object getCellEditorValue() {
            if (this.activeEditor == null) {
                return null;
            }
            return this.activeEditor.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Parameter<?> parameter;
            if (object instanceof String && ((String)((Object)(parameter = (String)object))).startsWith("Default: ")) {
                object = ((String)((Object)parameter)).substring("Default: ".length());
            }
            if (n < ParameterTable.this.parameters.size()) {
                parameter = ParameterTable.this.parameters.getNode((int)n).param;
                if (parameter instanceof Flag) {
                    this.activeEditor = this.dropdownEditor;
                    return this.dropdownEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                if (parameter instanceof ClassListParameter) {
                    this.activeEditor = this.classListEditor;
                    return this.classListEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                if (parameter instanceof ClassParameter) {
                    this.activeEditor = this.classListEditor;
                    return this.classListEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                if (parameter instanceof FileParameter) {
                    this.activeEditor = this.fileNameEditor;
                    return this.fileNameEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                if (parameter instanceof EnumParameter) {
                    this.activeEditor = this.dropdownEditor;
                    return this.dropdownEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
            }
            this.activeEditor = this.plaintextEditor;
            return this.plaintextEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private class ClassListEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        final JPanel panel;
        final JTextField textfield = new JTextField();
        final JButton button = new JButton("+");
        final TreePopup popup;
        private TreeModel model;
        private Parameter<?> option;

        public ClassListEditor() {
            this.textfield.addKeyListener(this);
            this.button.addActionListener(this);
            this.model = new DefaultTreeModel(new DefaultMutableTreeNode());
            this.popup = new TreePopup(this.model);
            this.popup.getTree().setRootVisible(false);
            this.popup.addActionListener(this);
            Icon icon = StockIcon.getStockIcon("go-next");
            Icon icon2 = StockIcon.getStockIcon("package");
            TreePopup.Renderer renderer = (TreePopup.Renderer)this.popup.getTree().getCellRenderer();
            renderer.setLeafIcon(icon);
            renderer.setFolderIcon(icon2);
            this.panel = new DispatchingPanel(this.textfield);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textfield, "Center");
            this.panel.add((Component)this.button, "East");
            this.textfield.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.button) {
                this.popup.show(this.panel);
                return;
            }
            if (actionEvent.getSource() == this.popup) {
                Object object;
                if (actionEvent.getActionCommand() == "canceled") {
                    this.popup.setVisible(false);
                    this.textfield.requestFocus();
                    return;
                }
                TreePath treePath = this.popup.getTree().getSelectionPath();
                Object object2 = object = treePath != null ? treePath.getLastPathComponent() : null;
                if (object instanceof ClassTree.ClassNode) {
                    String string;
                    ClassTree.ClassNode classNode = treePath != null ? (ClassTree.ClassNode)object : null;
                    String string2 = string = classNode != null ? classNode.getClassName() : null;
                    if (string != null && string.length() > 0) {
                        if (this.option instanceof ClassListParameter) {
                            String string3 = this.textfield.getText();
                            if (string3.equals("(optional)") || string3.startsWith("Default: ")) {
                                string3 = "";
                            }
                            string3 = string3.length() > 0 ? string3 + "," + string : string;
                            this.textfield.setText(string3);
                        } else {
                            this.textfield.setText(string);
                        }
                        this.popup.setVisible(false);
                        this.fireEditingStopped();
                        this.textfield.requestFocus();
                    }
                }
                return;
            }
            LoggingUtil.warning("Unrecognized action event in ClassListEditor: " + actionEvent);
        }

        @Override
        public Object getCellEditorValue() {
            return this.textfield.getText();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!((keyEvent.getModifiersEx() & 0x80) == 0 || keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 225 || this.popup.isVisible())) {
                this.popup.show(this.panel);
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n < ParameterTable.this.parameters.size()) {
                TreeNode treeNode;
                this.option = ParameterTable.this.parameters.getNode((int)n).param;
                if (this.option instanceof ClassListParameter) {
                    ClassListParameter classListParameter = (ClassListParameter)this.option;
                    treeNode = ClassTree.build(classListParameter.getKnownImplementations(), classListParameter.getRestrictionClass().getPackage().getName());
                    this.button.setText("+");
                } else if (this.option instanceof ClassParameter) {
                    ClassParameter classParameter = (ClassParameter)this.option;
                    treeNode = ClassTree.build(classParameter.getKnownImplementations(), classParameter.getRestrictionClass().getPackage().getName());
                    this.button.setText("v");
                } else {
                    treeNode = new DefaultMutableTreeNode();
                }
                if (this.option.isDefined()) {
                    if (this.option.tookDefaultValue()) {
                        this.textfield.setText("Default: " + this.option.getDefaultValueAsString());
                    } else {
                        this.textfield.setText(this.option.getValueAsString());
                    }
                } else {
                    this.textfield.setText("");
                }
                this.popup.getTree().setModel(new DefaultTreeModel(treeNode));
            }
            return this.panel;
        }
    }

    private class FileNameEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        final JPanel panel;
        final JTextField textfield = new JTextField();
        final JButton button = new JButton("...");
        int mode = 0;
        String defaultpath = new File(".").getAbsolutePath();

        public FileNameEditor() {
            this.button.addActionListener(this);
            this.panel = new DispatchingPanel(this.textfield);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textfield, "Center");
            this.panel.add((Component)this.button, "East");
            this.textfield.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.textfield.addKeyListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileDialog fileDialog = new FileDialog(ParameterTable.this.frame);
            fileDialog.setDirectory(this.defaultpath);
            fileDialog.setMode(this.mode);
            String string = this.textfield.getText();
            if (string != null && string.length() > 0) {
                fileDialog.setFile(string);
            }
            fileDialog.setVisible(true);
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                this.textfield.setText(new File(fileDialog.getDirectory(), string2).getPath());
            }
            fileDialog.setVisible(false);
            fileDialog.dispose();
            this.textfield.requestFocus();
            this.fireEditingStopped();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if ((keyEvent.getModifiersEx() & 0x80) != 0 && (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 225)) {
                keyEvent.consume();
                this.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "assist"));
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public Object getCellEditorValue() {
            return this.textfield.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Parameter<?> parameter;
            if (n < ParameterTable.this.parameters.size() && (parameter = ParameterTable.this.parameters.getNode((int)n).param) instanceof FileParameter) {
                FileParameter fileParameter = (FileParameter)parameter;
                File file = null;
                int n3 = this.mode = FileParameter.FileType.INPUT_FILE.equals((Object)fileParameter.getFileType()) ? 0 : 1;
                if (fileParameter.isDefined()) {
                    file = (File)fileParameter.getValue();
                }
                this.textfield.setText(file != null ? file.getPath() : "");
            }
            this.textfield.requestFocus();
            return this.panel;
        }
    }

    private class DropdownEditor
    extends DefaultCellEditor
    implements KeyListener {
        private static final long serialVersionUID = 1L;
        final JPanel panel;
        private final JComboBox<String> comboBox;

        public DropdownEditor(JComboBox<String> jComboBox) {
            super(jComboBox);
            this.comboBox = jComboBox;
            this.panel = new DispatchingPanel((JComponent)jComboBox.getEditor().getEditorComponent());
            this.panel.setLayout(new BorderLayout());
            this.panel.add(jComboBox, "Center");
            jComboBox.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!((keyEvent.getModifiersEx() & 0x80) == 0 || keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 225 || this.comboBox.isPopupVisible())) {
                this.comboBox.showPopup();
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Parameter<?> parameter;
            this.comboBox.removeAllItems();
            Object object2 = jTable.getValueAt(n, n2);
            if (object2 != null && object2 instanceof String) {
                parameter = (String)object2;
                if (((String)((Object)parameter)).equals("(optional)")) {
                    parameter = "";
                }
                if (((String)((Object)parameter)).startsWith("Default: ")) {
                    parameter = "";
                }
                if (parameter != "") {
                    this.comboBox.addItem((String)((Object)parameter));
                    this.comboBox.setSelectedIndex(0);
                }
            }
            if (n < ParameterTable.this.parameters.size()) {
                parameter = ParameterTable.this.parameters.getNode((int)n).param;
                if (parameter instanceof Flag) {
                    if (!"true".equals(object2)) {
                        this.comboBox.addItem("true");
                    }
                    if (!"false".equals(object2)) {
                        this.comboBox.addItem("false");
                    }
                } else if (parameter instanceof EnumParameter) {
                    EnumParameter enumParameter = (EnumParameter)parameter;
                    for (String string : enumParameter.getPossibleValues()) {
                        if (enumParameter.hasDefaultValue() && enumParameter.getDefaultValueAsString().equals(string)) {
                            this.comboBox.addItem("Default: " + string);
                            continue;
                        }
                        if (string.equals(object2)) continue;
                        this.comboBox.addItem(string);
                    }
                }
            }
            return this.panel;
        }
    }

    private class ColorfulRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object object) {
            if (object instanceof String) {
                this.setText((String)object);
                this.setToolTipText(null);
                return;
            }
            if (object instanceof DynamicParameters.Node) {
                Parameter<?> parameter = ((DynamicParameters.Node)object).param;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i < ((DynamicParameters.Node)object).depth; ++i) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(parameter.getOptionID().getName());
                this.setText(stringBuilder.toString());
                this.setToolTipText(parameter.getOptionID().getDescription());
                return;
            }
            this.setText("");
            this.setToolTipText(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl2 && n < ParameterTable.this.parameters.size()) {
                int n3 = ParameterTable.this.parameters.getNode((int)n).flags;
                component.setForeground(Color.BLACK);
                if ((n3 & 2) != 0) {
                    component.setBackground(COLOR_SYNTAX_ERROR);
                } else if ((n3 & 4) != 0) {
                    component.setBackground(COLOR_SYNTAX_ERROR);
                } else if ((n3 & 1) != 0) {
                    component.setBackground(COLOR_INCOMPLETE);
                } else if ((n3 & 0x10) != 0) {
                    component.setBackground(COLOR_DEFAULT_VALUE);
                } else if ((n3 & 8) != 0) {
                    component.setBackground(COLOR_OPTIONAL);
                } else {
                    component.setBackground(null);
                }
            }
            return component;
        }
    }

    protected class Handler
    implements KeyListener {
        protected Handler() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            ParameterTable parameterTable;
            if (!((keyEvent.getModifiersEx() & 0x80) == 0 || keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 225 || (parameterTable = ParameterTable.this).isEditing())) {
                int n = parameterTable.getSelectionModel().getLeadSelectionIndex();
                int n2 = parameterTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                parameterTable.editCellAt(n, n2);
                Component component = ParameterTable.this.getEditorComponent();
                if (component instanceof DispatchingPanel) {
                    KeyListener[] keyListenerArray;
                    for (KeyListener keyListener : keyListenerArray = ((DispatchingPanel)component).component.getKeyListeners()) {
                        keyListener.keyPressed(keyEvent);
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

