/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfunctions;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="M.S. Charikar", title="Similarity estimation techniques from rounding algorithms", booktitle="Proc. 34th ACM Symposium on Theory of computing, STOC'02", url="https://dx.doi.org/10.1145/509907.509965")
public class CosineLocalitySensitiveHashFunction
implements LocalitySensitiveHashFunction<NumberVector> {
    private RandomProjectionFamily.Projection projection;

    public CosineLocalitySensitiveHashFunction(RandomProjectionFamily.Projection projection) {
        this.projection = projection;
    }

    @Override
    public int hashObject(NumberVector numberVector) {
        double[] dArray = this.projection.project(numberVector);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n2 < dArray.length) {
            if (dArray[n2] > 0.0) {
                n |= n3;
            }
            ++n2;
            n3 <<= 1;
        }
        return n;
    }

    @Override
    public int hashObject(NumberVector numberVector, double[] dArray) {
        this.projection.project(numberVector, dArray);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n2 < dArray.length) {
            if (dArray[n2] > 0.0) {
                n |= n3;
            }
            ++n2;
            n3 <<= 1;
        }
        return n;
    }

    @Override
    public int getNumberOfProjections() {
        return this.projection.getOutputDimensionality();
    }
}

