/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.projected;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.LngLatToECEFProjection;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProjectedView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.geo.LngLatDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.projected.ProjectedIndex;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LngLatAsECEFIndex<O extends NumberVector>
extends ProjectedIndex<O, O> {
    public LngLatAsECEFIndex(Relation<O> relation, Projection<O, O> projection, Relation<O> relation2, Index index, boolean bl) {
        super(relation, projection, relation2, index, bl, 1.0);
    }

    @Override
    public String getLongName() {
        return "projected " + this.inner.getLongName();
    }

    @Override
    public String getShortName() {
        return "proj-" + this.inner.getShortName();
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!(this.inner instanceof KNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!LngLatDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object object : objectArray) {
            if (object != "exact") continue;
            return null;
        }
        DistanceQuery distanceQuery2 = EuclideanDistanceFunction.STATIC.instantiate(this.view);
        KNNQuery kNNQuery = ((KNNIndex)this.inner).getKNNQuery(distanceQuery2, objectArray);
        if (kNNQuery == null) {
            return null;
        }
        return new ProjectedIndex.ProjectedKNNQuery(this, distanceQuery, kNNQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!(this.inner instanceof RangeIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!LngLatDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object object : objectArray) {
            if (object != "exact") continue;
            return null;
        }
        DistanceQuery distanceQuery2 = EuclideanDistanceFunction.STATIC.instantiate(this.view);
        RangeQuery rangeQuery = ((RangeIndex)this.inner).getRangeQuery(distanceQuery2, objectArray);
        if (rangeQuery == null) {
            return null;
        }
        return new ProjectedIndex.ProjectedRangeQuery(this, distanceQuery, rangeQuery);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!(this.inner instanceof RKNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!LngLatDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object object : objectArray) {
            if (object != "exact") continue;
            return null;
        }
        DistanceQuery distanceQuery2 = EuclideanDistanceFunction.STATIC.instantiate(this.view);
        RKNNQuery rKNNQuery = ((RKNNIndex)this.inner).getRKNNQuery(distanceQuery2, objectArray);
        if (rKNNQuery == null) {
            return null;
        }
        return new ProjectedIndex.ProjectedRKNNQuery(this, distanceQuery, rKNNQuery);
    }

    public static class Factory<O extends NumberVector>
    extends ProjectedIndex.Factory<O, O> {
        public Factory(IndexFactory<O, ?> indexFactory, boolean bl, boolean bl2, EarthModel earthModel) {
            super(new LngLatToECEFProjection(earthModel), indexFactory, bl, bl2, 1.0);
        }

        @Override
        public ProjectedIndex<O, O> instantiate(Relation<O> relation) {
            AbstractRelation abstractRelation;
            DBIDs dBIDs;
            if (!this.proj.getInputDataTypeInformation().isAssignableFromType(relation.getDataTypeInformation())) {
                return null;
            }
            this.proj.initialize(relation.getDataTypeInformation());
            if (this.materialize) {
                dBIDs = relation.getDBIDs();
                WritableDataStore writableDataStore = DataStoreUtil.makeStorage(dBIDs, 30, this.proj.getOutputDataTypeInformation().getRestrictionClass());
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    writableDataStore.put(dBIDIter, this.proj.project(relation.get(dBIDIter)));
                    dBIDIter.advance();
                }
                abstractRelation = new MaterializedRelation("ECEF Projection", "ecef-projection", this.proj.getOutputDataTypeInformation(), writableDataStore, dBIDs);
            } else {
                abstractRelation = new ProjectedView(relation, this.proj);
            }
            dBIDs = this.inner.instantiate(abstractRelation);
            if (dBIDs == null) {
                return null;
            }
            return new LngLatAsECEFIndex<O>(relation, this.proj, abstractRelation, (Index)((Object)dBIDs), this.norefine);
        }

        public static class Parameterizer<O extends NumberVector>
        extends AbstractParameterizer {
            IndexFactory<O, ?> inner;
            boolean materialize = false;
            boolean norefine = false;
            EarthModel model;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                Flag flag;
                Flag flag2;
                ObjectParameter objectParameter;
                super.makeOptions(parameterization);
                ObjectParameter objectParameter2 = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
                if (parameterization.grab(objectParameter2)) {
                    this.model = (EarthModel)objectParameter2.instantiateClass(parameterization);
                }
                if (parameterization.grab(objectParameter = new ObjectParameter(ProjectedIndex.Factory.Parameterizer.INDEX_ID, IndexFactory.class))) {
                    this.inner = (IndexFactory)objectParameter.instantiateClass(parameterization);
                }
                if (parameterization.grab(flag2 = new Flag(ProjectedIndex.Factory.Parameterizer.MATERIALIZE_FLAG))) {
                    this.materialize = flag2.isTrue();
                }
                if (parameterization.grab(flag = new Flag(ProjectedIndex.Factory.Parameterizer.DISABLE_REFINE_FLAG))) {
                    this.norefine = flag.isTrue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner, this.materialize, this.norefine, this.model);
            }
        }
    }
}

