/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;

class MkMaxTreeNode<O>
extends AbstractMTreeNode<O, MkMaxTreeNode<O>, MkMaxEntry> {
    private static final long serialVersionUID = 1L;

    public MkMaxTreeNode() {
    }

    public MkMaxTreeNode(int n, boolean bl) {
        super(n, bl, MkMaxEntry.class);
    }

    protected double kNNDistance() {
        double d = 0.0;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            MkMaxEntry mkMaxEntry = (MkMaxEntry)this.getEntry(i);
            d = Math.max(d, mkMaxEntry.getKnnDistance());
        }
        return d;
    }

    @Override
    public boolean adjustEntry(MkMaxEntry mkMaxEntry, DBID dBID, double d, AbstractMTree<O, MkMaxTreeNode<O>, MkMaxEntry, ?> abstractMTree) {
        super.adjustEntry(mkMaxEntry, dBID, d, abstractMTree);
        mkMaxEntry.setKnnDistance(this.kNNDistance());
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkMaxEntry mkMaxEntry, MkMaxTreeNode<O> mkMaxTreeNode, int n, AbstractMTree<O, MkMaxTreeNode<O>, MkMaxEntry, ?> abstractMTree) {
        super.integrityCheckParameters(mkMaxEntry, mkMaxTreeNode, n, abstractMTree);
        MkMaxEntry mkMaxEntry2 = (MkMaxEntry)mkMaxTreeNode.getEntry(n);
        double d = this.kNNDistance();
        if (Math.abs(mkMaxEntry2.getKnnDistance() - d) > 0.0) {
            throw new RuntimeException("Wrong knnDistance in node " + mkMaxTreeNode.getPageID() + " at index " + n + " (child " + mkMaxEntry2 + ")" + "\nsoll: " + d + ",\n ist: " + mkMaxEntry2.getKnnDistance());
        }
    }
}

