/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.query.DoubleDistanceSearchCandidate;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Reference(authors="G. R. Hjaltason, H. Samet", title="Ranking in spatial databases", booktitle="Advances in Spatial Databases - 4th Symposium, SSD'95", url="http://dx.doi.org/10.1007/3-540-60159-7_6")
public class RStarTreeKNNQuery<O extends SpatialComparable>
implements KNNQuery<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    protected final SpatialPrimitiveDistanceFunction<? super O> distanceFunction;
    protected Relation<? extends O> relation;

    public RStarTreeKNNQuery(AbstractRStarTree<?, ?, ?> abstractRStarTree, Relation<? extends O> relation, SpatialPrimitiveDistanceFunction<? super O> spatialPrimitiveDistanceFunction) {
        this.relation = relation;
        this.tree = abstractRStarTree;
        this.distanceFunction = spatialPrimitiveDistanceFunction;
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
        return this.getKNNForObject((O)((SpatialComparable)this.relation.get(dBIDRef)), n);
    }

    @Override
    public KNNList getKNNForObject(O o, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("At least one neighbor has to be requested!");
        }
        this.tree.statistics.countKNNQuery();
        KNNHeap kNNHeap = DBIDUtil.newHeap(n);
        ComparableMinHeap<DoubleDistanceSearchCandidate> comparableMinHeap = new ComparableMinHeap<DoubleDistanceSearchCandidate>(Math.min(kNNHeap.getK() << 1, 21));
        double d = this.expandNode(o, kNNHeap, comparableMinHeap, Double.MAX_VALUE, this.tree.getRootID());
        while (!comparableMinHeap.isEmpty()) {
            DoubleDistanceSearchCandidate doubleDistanceSearchCandidate = (DoubleDistanceSearchCandidate)comparableMinHeap.poll();
            if (doubleDistanceSearchCandidate.mindist > d) break;
            d = this.expandNode(o, kNNHeap, comparableMinHeap, d, doubleDistanceSearchCandidate.nodeID);
        }
        return kNNHeap.toKNNList();
    }

    private double expandNode(O o, KNNHeap kNNHeap, ComparableMinHeap<DoubleDistanceSearchCandidate> comparableMinHeap, double d, int n) {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.tree.getNode(n);
        if (abstractRStarTreeNode.isLeaf()) {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                SpatialPointLeafEntry spatialPointLeafEntry = (SpatialPointLeafEntry)abstractRStarTreeNode.getEntry(i);
                double d2 = this.distanceFunction.minDist(spatialPointLeafEntry, (SpatialComparable)o);
                this.tree.statistics.countDistanceCalculation();
                if (!(d2 <= d)) continue;
                d = kNNHeap.insert(d2, spatialPointLeafEntry.getDBID());
            }
        } else {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                SpatialDirectoryEntry spatialDirectoryEntry = (SpatialDirectoryEntry)abstractRStarTreeNode.getEntry(i);
                double d3 = this.distanceFunction.minDist(spatialDirectoryEntry, (SpatialComparable)o);
                this.tree.statistics.countDistanceCalculation();
                if (d3 <= 0.0) {
                    this.expandNode(o, kNNHeap, comparableMinHeap, d, spatialDirectoryEntry.getPageID());
                    continue;
                }
                if (!(d3 <= d)) continue;
                comparableMinHeap.add(new DoubleDistanceSearchCandidate(d3, spatialDirectoryEntry.getPageID()));
            }
        }
        return d;
    }

    protected void batchNN(AbstractRStarTreeNode<?, ?> abstractRStarTreeNode, Map<DBID, KNNHeap> map) {
        if (abstractRStarTreeNode.isLeaf()) {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                SpatialEntry spatialEntry = (SpatialEntry)abstractRStarTreeNode.getEntry(i);
                for (Map.Entry<DBID, KNNHeap> doubleDistanceEntry : map.entrySet()) {
                    DBID d = doubleDistanceEntry.getKey();
                    KNNHeap kNNHeap = doubleDistanceEntry.getValue();
                    double d2 = kNNHeap.getKNNDistance();
                    DBID kNNHeap2 = ((LeafEntry)((Object)spatialEntry)).getDBID();
                    double d3 = this.distanceFunction.distance(this.relation.get(kNNHeap2), this.relation.get(d));
                    this.tree.statistics.countDistanceCalculation();
                    if (!(d3 <= d2)) continue;
                    kNNHeap.insert(d3, kNNHeap2);
                }
            }
        } else {
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(map.size());
            for (DBID object2 : map.keySet()) {
                arrayModifiableDBIDs.add(object2);
            }
            List<DoubleDistanceEntry> list = this.getSortedEntries(abstractRStarTreeNode, arrayModifiableDBIDs);
            Iterator iterator = list.iterator();
            block3: while (iterator.hasNext()) {
                DoubleDistanceEntry doubleDistanceEntry = (DoubleDistanceEntry)iterator.next();
                double d = doubleDistanceEntry.distance;
                for (Map.Entry<DBID, KNNHeap> entry : map.entrySet()) {
                    KNNHeap kNNHeap = entry.getValue();
                    double d3 = kNNHeap.getKNNDistance();
                    if (!(d <= d3)) continue;
                    SpatialEntry spatialEntry = doubleDistanceEntry.entry;
                    AbstractRStarTreeNode abstractRStarTreeNode2 = (AbstractRStarTreeNode)this.tree.getNode(((DirectoryEntry)((Object)spatialEntry)).getPageID().intValue());
                    this.batchNN(abstractRStarTreeNode2, map);
                    continue block3;
                }
            }
        }
    }

    protected List<DoubleDistanceEntry> getSortedEntries(AbstractRStarTreeNode<?, ?> abstractRStarTreeNode, DBIDs dBIDs) {
        ArrayList<DoubleDistanceEntry> arrayList = new ArrayList<DoubleDistanceEntry>();
        for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
            SpatialEntry spatialEntry = (SpatialEntry)abstractRStarTreeNode.getEntry(i);
            double d = Double.MAX_VALUE;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                double d2 = this.distanceFunction.minDist(spatialEntry, (SpatialComparable)this.relation.get(dBIDIter));
                this.tree.statistics.countDistanceCalculation();
                d = Math.min(d2, d);
                dBIDIter.advance();
            }
            arrayList.add(new DoubleDistanceEntry(spatialEntry, d));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        DBIDRef dBIDRef;
        if (n < 1) {
            throw new IllegalArgumentException("At least one enumeration has to be requested!");
        }
        HashMap<DBID, KNNHeap> hashMap = new HashMap<DBID, KNNHeap>(arrayDBIDs.size());
        Object object = arrayDBIDs.iter();
        while (object.valid()) {
            dBIDRef = DBIDUtil.deref((DBIDRef)object);
            hashMap.put((DBID)dBIDRef, DBIDUtil.newHeap(n));
            object.advance();
        }
        this.batchNN((AbstractRStarTreeNode)this.tree.getRoot(), hashMap);
        object = new ArrayList();
        dBIDRef = arrayDBIDs.iter();
        while (dBIDRef.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDRef);
            this.tree.statistics.countKNNQuery();
            object.add(((KNNHeap)hashMap.get(dBID)).toKNNList());
            dBIDRef.advance();
        }
        return object;
    }

    static class DoubleDistanceEntry
    implements Comparable<DoubleDistanceEntry> {
        SpatialEntry entry;
        double distance;

        public DoubleDistanceEntry(SpatialEntry spatialEntry, double d) {
            this.entry = spatialEntry;
            this.distance = d;
        }

        @Override
        public int compareTo(DoubleDistanceEntry doubleDistanceEntry) {
            return Double.compare(this.distance, doubleDistanceEntry.distance);
        }
    }
}

