/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNTreeHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdkNNSettings;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RdKNNTree<O extends NumberVector>
extends NonFlatRStarTree<RdKNNNode, RdKNNEntry, RdkNNSettings<O>>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O>,
DynamicIndex {
    private static final Logging LOG = Logging.getLogger(RdKNNTree.class);
    private SpatialDistanceQuery<O> distanceQuery;
    protected KNNQuery<O> knnQuery;
    private Relation<O> relation;

    public RdKNNTree(Relation<O> relation, PageFile<RdKNNNode> pageFile, RdkNNSettings<O> rdkNNSettings) {
        super(pageFile, rdkNNSettings);
        this.relation = relation;
        this.distanceQuery = rdkNNSettings.distanceFunction.instantiate(relation);
        this.knnQuery = relation.getKNNQuery(this.distanceQuery, new Object[0]);
    }

    @Override
    protected void preInsert(RdKNNEntry rdKNNEntry) {
        KNNHeap kNNHeap = DBIDUtil.newHeap(((RdkNNSettings)this.settings).k_max);
        this.preInsert(rdKNNEntry, (RdKNNEntry)this.getRootEntry(), kNNHeap);
    }

    @Override
    protected void postDelete(RdKNNEntry rdKNNEntry) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNN((RdKNNNode)this.getRoot(), ((RdKNNLeafEntry)rdKNNEntry).getDBID(), modifiableDoubleDBIDList);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(modifiableDoubleDBIDList);
        arrayModifiableDBIDs.sort();
        List<KNNList> list = this.knnQuery.getKNNForBulkDBIDs(arrayModifiableDBIDs, ((RdkNNSettings)this.settings).k_max);
        this.adjustKNNDistance((RdKNNEntry)this.getRootEntry(), arrayModifiableDBIDs, list);
    }

    @Override
    protected void bulkLoad(List<RdKNNEntry> list) {
        super.bulkLoad(list);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(list.size());
        for (RdKNNEntry rdKNNEntry : list) {
            DBID dBID = ((RdKNNLeafEntry)rdKNNEntry).getDBID();
            arrayModifiableDBIDs.add(dBID);
        }
        arrayModifiableDBIDs.sort();
        List<KNNList> list2 = this.knnQuery.getKNNForBulkDBIDs(arrayModifiableDBIDs, ((RdkNNSettings)this.settings).k_max);
        this.adjustKNNDistance((RdKNNEntry)this.getRootEntry(), arrayModifiableDBIDs, (List<KNNList>)list2);
        this.doExtraIntegrityChecks();
    }

    public DoubleDBIDList reverseKNNQuery(DBID dBID, int n, SpatialPrimitiveDistanceFunction<? super O> spatialPrimitiveDistanceFunction, KNNQuery<O> kNNQuery) {
        this.checkDistanceFunction(spatialPrimitiveDistanceFunction);
        if (n > ((RdkNNSettings)this.settings).k_max) {
            throw new IllegalArgumentException("Parameter k is not supported, k > k_max: " + n + " > " + ((RdkNNSettings)this.settings).k_max);
        }
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNN((RdKNNNode)this.getRoot(), dBID, modifiableDoubleDBIDList);
        if (n == ((RdkNNSettings)this.settings).k_max) {
            modifiableDoubleDBIDList.sort();
            return modifiableDoubleDBIDList;
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(modifiableDoubleDBIDList);
        arrayModifiableDBIDs.sort();
        List<KNNList> list = kNNQuery.getKNNForBulkDBIDs(arrayModifiableDBIDs, n);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList2 = DBIDUtil.newDistanceDBIDList();
        int n2 = 0;
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        while (dBIDArrayMIter.valid()) {
            DoubleDBIDListIter doubleDBIDListIter = list.get(n2).iter();
            while (doubleDBIDListIter.valid()) {
                if (DBIDUtil.equal(dBID, doubleDBIDListIter)) {
                    modifiableDoubleDBIDList2.add(doubleDBIDListIter.doubleValue(), dBIDArrayMIter);
                    break;
                }
                doubleDBIDListIter.advance();
            }
            dBIDArrayMIter.advance();
            ++n2;
        }
        modifiableDoubleDBIDList2.sort();
        return modifiableDoubleDBIDList2;
    }

    public List<ModifiableDoubleDBIDList> bulkReverseKNNQueryForID(DBIDs dBIDs, int n, SpatialPrimitiveDistanceFunction<? super O> spatialPrimitiveDistanceFunction, KNNQuery<O> kNNQuery) {
        Object object3;
        Object object2;
        this.checkDistanceFunction(spatialPrimitiveDistanceFunction);
        if (n > ((RdkNNSettings)this.settings).k_max) {
            throw new IllegalArgumentException("Parameter k is not supported, k > k_max: " + n + " > " + ((RdkNNSettings)this.settings).k_max);
        }
        HashMap<DBID, ModifiableDoubleDBIDList> hashMap = new HashMap<DBID, ModifiableDoubleDBIDList>();
        ArrayList<ModifiableDoubleDBIDList> arrayList = dBIDs.iter();
        while (arrayList.valid()) {
            object2 = DBIDUtil.deref((DBIDRef)((Object)arrayList));
            hashMap.put((DBID)object2, DBIDUtil.newDistanceDBIDList());
            arrayList.advance();
        }
        this.doBulkReverseKNN((RdKNNNode)this.getRoot(), dBIDs, hashMap);
        if (n == ((RdkNNSettings)this.settings).k_max) {
            arrayList = new ArrayList<ModifiableDoubleDBIDList>();
            for (ModifiableDoubleDBIDList modifiableDoubleDBIDList : hashMap.values()) {
                modifiableDoubleDBIDList.sort();
                arrayList.add(modifiableDoubleDBIDList);
            }
            return arrayList;
        }
        arrayList = DBIDUtil.newArray();
        for (Object object3 : hashMap.values()) {
            arrayList.addDBIDs((DBIDs)object3);
        }
        arrayList.sort();
        object2 = kNNQuery.getKNNForBulkDBIDs((ArrayDBIDs)((Object)arrayList), n);
        object3 = new ArrayList();
        for (DBID dBID : hashMap.keySet()) {
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = (ModifiableDoubleDBIDList)hashMap.get(dBID);
            ModifiableDoubleDBIDList modifiableDoubleDBIDList2 = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
            while (doubleDBIDListMIter.valid()) {
                int n2 = arrayList.binarySearch(doubleDBIDListMIter);
                assert (n2 >= 0);
                DoubleDBIDListIter doubleDBIDListIter = ((KNNList)object2.get(n2)).iter();
                while (doubleDBIDListIter.valid()) {
                    if (DBIDUtil.equal(dBID, doubleDBIDListIter)) {
                        modifiableDoubleDBIDList2.add(doubleDBIDListIter.doubleValue(), doubleDBIDListMIter);
                        break;
                    }
                    doubleDBIDListIter.advance();
                }
                doubleDBIDListMIter.advance();
            }
            object3.add(modifiableDoubleDBIDList2);
        }
        return object3;
    }

    @Override
    protected TreeIndexHeader createHeader() {
        return new RdKNNTreeHeader(this.getPageSize(), this.dirCapacity, this.leafCapacity, this.dirMinimum, this.leafCapacity, ((RdkNNSettings)this.settings).k_max);
    }

    @Override
    protected void initializeCapacities(RdKNNEntry rdKNNEntry) {
        int n = rdKNNEntry.getDimensionality();
        int n2 = 8;
        double d = 16.125;
        if ((double)this.getPageSize() - d < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)(((double)this.getPageSize() - d) / (double)(4 + 16 * n + n2)) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.dirMinimum = (int)Math.round((double)(this.dirCapacity - 1) * 0.5);
        if (this.dirMinimum < 2) {
            this.dirMinimum = 2;
        }
        this.leafCapacity = (int)(((double)this.getPageSize() - d) / (double)(4 + 8 * n + n2)) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
        this.leafMinimum = (int)Math.round((double)(this.leafCapacity - 1) * 0.5);
        if (this.leafMinimum < 2) {
            this.leafMinimum = 2;
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Directory Capacity: " + this.dirCapacity + "\nLeaf Capacity: " + this.leafCapacity);
        }
    }

    protected List<DoubleObjPair<RdKNNEntry>> getSortedEntries(AbstractRStarTreeNode<?, ?> abstractRStarTreeNode, SpatialComparable spatialComparable, SpatialPrimitiveDistanceFunction<?> spatialPrimitiveDistanceFunction) {
        ArrayList<DoubleObjPair<RdKNNEntry>> arrayList = new ArrayList<DoubleObjPair<RdKNNEntry>>();
        for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
            RdKNNEntry rdKNNEntry = (RdKNNEntry)abstractRStarTreeNode.getEntry(i);
            double d = spatialPrimitiveDistanceFunction.minDist(rdKNNEntry, spatialComparable);
            arrayList.add(new DoubleObjPair<RdKNNEntry>(d, rdKNNEntry));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void preInsert(RdKNNEntry rdKNNEntry, RdKNNEntry rdKNNEntry2, KNNHeap kNNHeap) {
        double d = kNNHeap.getKNNDistance();
        RdKNNNode rdKNNNode = (RdKNNNode)this.getNode(rdKNNEntry2);
        double d2 = 0.0;
        if (rdKNNNode.isLeaf()) {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNLeafEntry rdKNNLeafEntry = (RdKNNLeafEntry)rdKNNNode.getEntry(i);
                double d3 = this.distanceQuery.distance((DBIDRef)rdKNNLeafEntry.getDBID(), (DBIDRef)((LeafEntry)((Object)rdKNNEntry)).getDBID());
                if (d3 <= d) {
                    kNNHeap.insert(d3, rdKNNLeafEntry.getDBID());
                    if (kNNHeap.size() >= ((RdkNNSettings)this.settings).k_max) {
                        d = kNNHeap.getKNNDistance();
                        rdKNNEntry.setKnnDistance(d);
                    }
                }
                if (d3 <= rdKNNLeafEntry.getKnnDistance()) {
                    NumberVector numberVector = (NumberVector)this.relation.get(rdKNNLeafEntry.getDBID());
                    KNNList kNNList = this.knnQuery.getKNNForObject(numberVector, ((RdkNNSettings)this.settings).k_max);
                    if (kNNList.size() + 1 < ((RdkNNSettings)this.settings).k_max) {
                        rdKNNLeafEntry.setKnnDistance(Double.NaN);
                    } else {
                        double d4 = Math.min(kNNList.get(kNNList.size() - 1).doubleValue(), d3);
                        rdKNNLeafEntry.setKnnDistance(d4);
                    }
                }
                d2 = Math.max(d2, rdKNNLeafEntry.getKnnDistance());
            }
        } else {
            NumberVector numberVector = (NumberVector)this.relation.get(((LeafEntry)((Object)rdKNNEntry)).getDBID());
            List<DoubleObjPair<RdKNNEntry>> list = this.getSortedEntries(rdKNNNode, numberVector, ((RdkNNSettings)this.settings).distanceFunction);
            for (DoubleObjPair<RdKNNEntry> doubleObjPair : list) {
                RdKNNEntry rdKNNEntry3 = (RdKNNEntry)doubleObjPair.second;
                double d5 = rdKNNEntry3.getKnnDistance();
                if (doubleObjPair.first < d5 || doubleObjPair.first < d) {
                    this.preInsert(rdKNNEntry, rdKNNEntry3, kNNHeap);
                    d = kNNHeap.getKNNDistance();
                }
                d2 = Math.max(d2, rdKNNEntry3.getKnnDistance());
            }
        }
        rdKNNEntry2.setKnnDistance(d2);
    }

    private void doReverseKNN(RdKNNNode rdKNNNode, DBID dBID, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        if (rdKNNNode.isLeaf()) {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNLeafEntry rdKNNLeafEntry = (RdKNNLeafEntry)rdKNNNode.getEntry(i);
                double d = this.distanceQuery.distance((DBIDRef)rdKNNLeafEntry.getDBID(), (DBIDRef)dBID);
                if (!(d <= rdKNNLeafEntry.getKnnDistance())) continue;
                modifiableDoubleDBIDList.add(d, rdKNNLeafEntry.getDBID());
            }
        } else {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNDirectoryEntry rdKNNDirectoryEntry = (RdKNNDirectoryEntry)rdKNNNode.getEntry(i);
                double d = this.distanceQuery.minDist((SpatialComparable)rdKNNDirectoryEntry, dBID);
                if (!(d <= rdKNNDirectoryEntry.getKnnDistance())) continue;
                this.doReverseKNN((RdKNNNode)this.getNode(rdKNNDirectoryEntry), dBID, modifiableDoubleDBIDList);
            }
        }
    }

    private void doBulkReverseKNN(RdKNNNode rdKNNNode, DBIDs dBIDs, Map<DBID, ModifiableDoubleDBIDList> map) {
        if (rdKNNNode.isLeaf()) {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNLeafEntry rdKNNLeafEntry = (RdKNNLeafEntry)rdKNNNode.getEntry(i);
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    DBID dBID = DBIDUtil.deref(dBIDIter);
                    double d = this.distanceQuery.distance((DBIDRef)rdKNNLeafEntry.getDBID(), (DBIDRef)dBID);
                    if (d <= rdKNNLeafEntry.getKnnDistance()) {
                        map.get(dBID).add(d, rdKNNLeafEntry.getDBID());
                    }
                    dBIDIter.advance();
                }
            }
        } else {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNDirectoryEntry rdKNNDirectoryEntry = (RdKNNDirectoryEntry)rdKNNNode.getEntry(i);
                ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    DBID dBID = DBIDUtil.deref(dBIDIter);
                    double d = this.distanceQuery.minDist((SpatialComparable)rdKNNDirectoryEntry, dBID);
                    if (d <= rdKNNDirectoryEntry.getKnnDistance()) {
                        arrayModifiableDBIDs.add(dBID);
                    }
                    if (!arrayModifiableDBIDs.isEmpty()) {
                        this.doBulkReverseKNN((RdKNNNode)this.getNode(rdKNNDirectoryEntry), arrayModifiableDBIDs, map);
                    }
                    dBIDIter.advance();
                }
            }
        }
    }

    private void adjustKNNDistance(RdKNNEntry rdKNNEntry, ArrayDBIDs arrayDBIDs, List<? extends KNNList> list) {
        RdKNNNode rdKNNNode = (RdKNNNode)this.getNode(rdKNNEntry);
        double d = 0.0;
        if (rdKNNNode.isLeaf()) {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNEntry rdKNNEntry2 = (RdKNNEntry)rdKNNNode.getEntry(i);
                DBID dBID = ((LeafEntry)((Object)rdKNNEntry2)).getDBID();
                int n = arrayDBIDs.binarySearch(dBID);
                if (n >= 0) {
                    rdKNNEntry2.setKnnDistance(list.get(n).getKNNDistance());
                }
                d = Math.max(d, rdKNNEntry2.getKnnDistance());
            }
        } else {
            for (int i = 0; i < rdKNNNode.getNumEntries(); ++i) {
                RdKNNEntry rdKNNEntry3 = (RdKNNEntry)rdKNNNode.getEntry(i);
                this.adjustKNNDistance(rdKNNEntry3, arrayDBIDs, list);
                d = Math.max(d, rdKNNEntry3.getKnnDistance());
            }
        }
        rdKNNEntry.setKnnDistance(d);
    }

    @Override
    protected RdKNNNode createNewLeafNode() {
        return new RdKNNNode(this.leafCapacity, true);
    }

    @Override
    protected RdKNNNode createNewDirectoryNode() {
        return new RdKNNNode(this.dirCapacity, false);
    }

    @Override
    protected RdKNNEntry createNewDirectoryEntry(RdKNNNode rdKNNNode) {
        return new RdKNNDirectoryEntry(rdKNNNode.getPageID(), rdKNNNode.computeMBR(), rdKNNNode.kNNDistance());
    }

    @Override
    protected RdKNNEntry createRootEntry() {
        return new RdKNNDirectoryEntry(0, null, Double.NaN);
    }

    private void checkDistanceFunction(SpatialPrimitiveDistanceFunction<? super O> spatialPrimitiveDistanceFunction) {
        if (!((RdkNNSettings)this.settings).distanceFunction.equals(spatialPrimitiveDistanceFunction)) {
            throw new IllegalArgumentException("Parameter distanceFunction must be an instance of " + this.distanceQuery.getClass() + ", but is " + spatialPrimitiveDistanceFunction.getClass());
        }
    }

    protected RdKNNLeafEntry createNewLeafEntry(DBID dBID) {
        return new RdKNNLeafEntry(dBID, (NumberVector)this.relation.get(dBID), Double.NaN);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public final void insert(DBIDRef dBIDRef) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref(dBIDRef)));
    }

    @Override
    public final void insertAll(DBIDs dBIDs) {
        if (dBIDs.isEmpty() || dBIDs.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<RdKNNEntry> arrayList = new ArrayList<RdKNNEntry>(dBIDs.size());
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                arrayList.add(this.createNewLeafEntry(DBIDUtil.deref(dBIDIter)));
                dBIDIter.advance();
            }
            this.bulkLoad((List<RdKNNEntry>)arrayList);
        } else {
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                this.insert(dBIDIter);
                dBIDIter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public final boolean delete(DBIDRef dBIDRef) {
        NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
        IndexTreePath indexTreePath = this.findPathToObject(this.getRootPath(), numberVector, dBIDRef);
        if (indexTreePath == null) {
            return false;
        }
        this.deletePath(indexTreePath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.delete(DBIDUtil.deref(dBIDIter));
            dBIDIter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        return RStarTreeUtil.getRangeQuery(this, (SpatialDistanceQuery)distanceQuery, objectArray);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        return RStarTreeUtil.getKNNQuery(this, (SpatialDistanceQuery)distanceQuery, objectArray);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        return null;
    }

    @Override
    public String getLongName() {
        return "RdKNNTree";
    }

    @Override
    public String getShortName() {
        return "rdknntree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

