/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialSingleMinComparator;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.bulk.MaxExtensionBulkSplit"})
public class MaxExtensionBulkSplit
extends AbstractBulkSplit {
    private static final Logging LOG = Logging.getLogger(MaxExtensionBulkSplit.class);
    public static final MaxExtensionBulkSplit STATIC = new MaxExtensionBulkSplit();

    public <N extends SpatialComparable> List<List<N>> partition(List<N> list, int n, int n2) {
        ArrayList<List<N>> arrayList = new ArrayList<List<N>>();
        ArrayList<N> arrayList2 = new ArrayList<N>(list);
        while (arrayList2.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = this.chooseMaximalExtendedSplitAxis(arrayList2);
            int n4 = this.chooseBulkSplitPoint(arrayList2.size(), n, n2);
            if (LOG.isDebugging()) {
                stringBuilder.append("\nsplitAxis ").append(n3);
                stringBuilder.append("\nsplitPoint ").append(n4);
            }
            Collections.sort(arrayList2, new SpatialSingleMinComparator(n3));
            ArrayList<SpatialComparable> arrayList3 = new ArrayList<SpatialComparable>();
            for (int i = 0; i < n4; ++i) {
                SpatialComparable spatialComparable = (SpatialComparable)arrayList2.remove(0);
                arrayList3.add(spatialComparable);
            }
            arrayList.add(arrayList3);
            if (!LOG.isDebugging()) continue;
            stringBuilder.append("\ncurrent partition ").append(arrayList3);
            stringBuilder.append("\nremaining objects # ").append(arrayList2.size());
            LOG.debugFine(stringBuilder.toString());
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("partitions " + arrayList);
        }
        return arrayList;
    }

    private int chooseMaximalExtendedSplitAxis(List<? extends SpatialComparable> list) {
        int n = list.get(0).getDimensionality();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        Arrays.fill(dArray2, Double.MAX_VALUE);
        for (SpatialComparable spatialComparable : list) {
            for (int i = 0; i < n; ++i) {
                double d = spatialComparable.getMin(i);
                double d2 = spatialComparable.getMax(i);
                if (dArray[i] < d2) {
                    dArray[i] = d2;
                }
                if (!(dArray2[i] > d)) continue;
                dArray2[i] = d;
            }
        }
        int n2 = -1;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i] - dArray2[i];
            if (!(d < d3)) continue;
            d = d3;
            n2 = i;
        }
        return n2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MaxExtensionBulkSplit makeInstance() {
            return STATIC;
        }
    }
}

