/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.LeastEnlargementWithAreaInsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.LeastOverlapInsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;

@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
public class CombinedInsertionStrategy
implements InsertionStrategy {
    InsertionStrategy dirStrategy;
    InsertionStrategy leafStrategy;

    public CombinedInsertionStrategy(InsertionStrategy insertionStrategy, InsertionStrategy insertionStrategy2) {
        this.dirStrategy = insertionStrategy;
        this.leafStrategy = insertionStrategy2;
    }

    @Override
    public <A> int choose(A a, ArrayAdapter<? extends SpatialComparable, A> arrayAdapter, SpatialComparable spatialComparable, int n, int n2) {
        if (n2 + 1 >= n) {
            return this.leafStrategy.choose(a, arrayAdapter, spatialComparable, n, n2);
        }
        return this.dirStrategy.choose(a, arrayAdapter, spatialComparable, n, n2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIR_STRATEGY_ID = new OptionID("rtree.insert-directory", "Insertion strategy for directory nodes.");
        public static final OptionID LEAF_STRATEGY_ID = new OptionID("rtree.insert-leaf", "Insertion strategy for leaf nodes.");
        InsertionStrategy dirStrategy;
        InsertionStrategy leafStrategy;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ClassParameter classParameter;
            super.makeOptions(parameterization);
            ClassParameter classParameter2 = new ClassParameter(DIR_STRATEGY_ID, InsertionStrategy.class, LeastEnlargementWithAreaInsertionStrategy.class);
            if (parameterization.grab(classParameter2)) {
                this.dirStrategy = (InsertionStrategy)classParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(classParameter = new ClassParameter(LEAF_STRATEGY_ID, InsertionStrategy.class, LeastOverlapInsertionStrategy.class))) {
                this.leafStrategy = (InsertionStrategy)classParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected CombinedInsertionStrategy makeInstance() {
            return new CombinedInsertionStrategy(this.dirStrategy, this.leafStrategy);
        }
    }
}

