/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;

public abstract class DimensionSimilarityMatrix {
    public static final PrimAdapter PRIM_ADAPTER = new PrimAdapter();
    private final double[] sim;

    protected DimensionSimilarityMatrix(int n) {
        this.sim = new double[this.index(0, n)];
    }

    public abstract int size();

    public abstract int dim(int var1);

    public void set(int n, int n2, double d) {
        this.sim[this.index((int)n, (int)n2)] = d;
    }

    public double get(int n, int n2) {
        return this.sim[this.index(n, n2)];
    }

    private int index(int n, int n2) {
        assert (n != n2);
        if (n > n2) {
            return this.index(n2, n);
        }
        return (n2 * (n2 - 1) >> 1) + n;
    }

    public Matrix copyToFullMatrix() {
        int n = this.size();
        Matrix matrix = new Matrix(n, n);
        double[][] dArray = matrix.getArrayRef();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                dArray[j][i] = this.sim[n2];
                dArray[i][j] = this.sim[n2];
                ++n2;
            }
        }
        return matrix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (j > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.get(i, j));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static DimensionSimilarityMatrix make(int n) {
        return new FullDimensionSimilarityMatrix(n);
    }

    public static DimensionSimilarityMatrix make(int[] nArray) {
        return new PartialDimensionSimilarityMatrix(nArray);
    }

    public static class PrimAdapter
    implements PrimsMinimumSpanningTree.Adapter<DimensionSimilarityMatrix> {
        protected PrimAdapter() {
        }

        @Override
        public double distance(DimensionSimilarityMatrix dimensionSimilarityMatrix, int n, int n2) {
            return -Math.abs(dimensionSimilarityMatrix.get(n, n2));
        }

        @Override
        public int size(DimensionSimilarityMatrix dimensionSimilarityMatrix) {
            return dimensionSimilarityMatrix.size();
        }
    }

    public static class PartialDimensionSimilarityMatrix
    extends DimensionSimilarityMatrix {
        final int[] dims;

        public PartialDimensionSimilarityMatrix(int[] nArray) {
            super(nArray.length);
            this.dims = nArray;
        }

        @Override
        public int size() {
            return this.dims.length;
        }

        @Override
        public int dim(int n) {
            return this.dims[n];
        }
    }

    public static class FullDimensionSimilarityMatrix
    extends DimensionSimilarityMatrix {
        final int dims;

        public FullDimensionSimilarityMatrix(int n) {
            super(n);
            this.dims = n;
        }

        @Override
        public int size() {
            return this.dims;
        }

        @Override
        public int dim(int n) {
            return n;
        }
    }
}

