/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geodesy;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geodesy.AbstractEarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphereUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class SphericalCosineEarthModel
extends AbstractEarthModel {
    public static final SphericalCosineEarthModel STATIC = new SphericalCosineEarthModel();
    public static final double EARTH_RADIUS = 6371009.0;

    protected SphericalCosineEarthModel() {
        super(6371009.0, 6371009.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public double[] latLngRadToECEF(double d, double d2) {
        double d3 = Math.cos(d);
        double d4 = MathUtil.cosToSin(d, d3);
        double d5 = Math.cos(d2);
        double d6 = MathUtil.cosToSin(d2, d5);
        return new double[]{6371009.0 * d3 * d5, 6371009.0 * d3 * d6, 6371009.0 * d4};
    }

    @Override
    public double[] latLngRadToECEF(double d, double d2, double d3) {
        double d4 = Math.cos(d);
        double d5 = MathUtil.cosToSin(d, d4);
        double d6 = Math.cos(d2);
        double d7 = MathUtil.cosToSin(d2, d6);
        return new double[]{(6371009.0 + d3) * d4 * d6, (6371009.0 + d3) * d4 * d7, (6371009.0 + d3) * d5};
    }

    @Override
    public double ecefToLatRad(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2);
        return Math.atan2(d3, d4);
    }

    @Override
    public double distanceRad(double d, double d2, double d3, double d4) {
        return 6371009.0 * SphereUtil.cosineFormulaRad(d, d2, d3, d4);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SphericalCosineEarthModel makeInstance() {
            return STATIC;
        }
    }
}

