/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.util.Arrays;

public class AffineTransformation {
    private int dim;
    private Matrix trans;
    private Matrix inv = null;

    public AffineTransformation(int n) {
        this.dim = n;
        this.trans = Matrix.unitMatrix(n + 1);
    }

    public AffineTransformation(int n, Matrix matrix, Matrix matrix2) {
        this.dim = n;
        this.trans = matrix;
        this.inv = matrix2;
    }

    public static AffineTransformation reorderAxesTransformation(int n, int[] nArray) {
        int n2;
        Matrix matrix = Matrix.zeroMatrix(n + 1);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            assert (0 < nArray[n2] && nArray[n2] <= n);
            matrix.set(n2, nArray[n2] - 1, 1.0);
        }
        n2 = 1;
        for (int i = nArray.length; i < n + 1; ++i) {
            boolean bl = true;
            block2: while (bl) {
                bl = false;
                for (int n3 : nArray) {
                    if (n3 != n2) continue;
                    bl = true;
                    ++n2;
                    continue block2;
                }
            }
            matrix.set(i, n2 - 1, 1.0);
            ++n2;
        }
        assert (n2 - 2 == n);
        return new AffineTransformation(n, matrix, null);
    }

    public AffineTransformation clone() {
        return new AffineTransformation(this.dim, this.trans, this.inv);
    }

    public int getDimensionality() {
        return this.dim;
    }

    public void addTranslation(Vector vector) {
        assert (vector.getDimensionality() == this.dim);
        this.inv = null;
        Matrix matrix = Matrix.unitMatrix(this.dim + 1);
        for (int i = 0; i < this.dim; ++i) {
            matrix.set(i, this.dim, vector.get(i));
        }
        this.trans = matrix.times(this.trans);
    }

    public void addTranslation(double[] dArray) {
        assert (dArray.length == this.dim);
        this.inv = null;
        Matrix matrix = Matrix.unitMatrix(this.dim + 1);
        for (int i = 0; i < this.dim; ++i) {
            matrix.set(i, this.dim, dArray[i]);
        }
        this.trans = matrix.times(this.trans);
    }

    public void addMatrix(Matrix matrix) {
        assert (matrix.getRowDimensionality() == this.dim);
        assert (matrix.getColumnDimensionality() == this.dim);
        this.inv = null;
        double[][] dArray = new double[this.dim + 1][this.dim + 1];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[i][j] = matrix.get(i, j);
            }
        }
        dArray[this.dim][this.dim] = 1.0;
        this.trans = new Matrix(dArray).times(this.trans);
    }

    public void addRotation(int n, int n2, double d) {
        assert (n >= 0);
        assert (n < this.dim);
        assert (n >= 0);
        assert (n2 < this.dim);
        assert (n != n2);
        this.inv = null;
        double[][] dArray = new double[this.dim + 1][this.dim + 1];
        for (int i = 0; i < this.dim + 1; ++i) {
            dArray[i][i] = 1.0;
        }
        double d2 = Math.cos(d);
        double d3 = MathUtil.cosToSin(d, d2);
        dArray[n][n] = d2;
        dArray[n][n2] = -d3;
        dArray[n2][n] = d3;
        dArray[n2][n2] = d2;
        this.trans = new Matrix(dArray).times(this.trans);
    }

    public void addAxisReflection(int n) {
        assert (0 < n && n <= this.dim);
        this.inv = null;
        for (int i = 0; i <= this.dim; ++i) {
            this.trans.set(n - 1, i, -this.trans.get(n - 1, i));
        }
    }

    public void addScaling(double d) {
        this.inv = null;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j <= this.dim; ++j) {
                this.trans.set(i, j, this.trans.get(i, j) * d);
            }
        }
    }

    public Matrix getTransformation() {
        return this.trans;
    }

    public Matrix getInverse() {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.inv;
    }

    private void updateInverse() {
        this.inv = this.trans.inverse();
    }

    public Vector homogeneVector(Vector vector) {
        assert (vector.getDimensionality() == this.dim);
        double[] dArray = Arrays.copyOf(vector.getArrayRef(), this.dim + 1);
        dArray[this.dim] = 1.0;
        return new Vector(dArray);
    }

    public double[] homogeneVector(double[] dArray) {
        assert (dArray.length == this.dim);
        double[] dArray2 = Arrays.copyOf(dArray, this.dim + 1);
        dArray2[this.dim] = 1.0;
        return dArray2;
    }

    public Vector homogeneRelativeVector(Vector vector) {
        assert (vector.getDimensionality() == this.dim);
        double[] dArray = Arrays.copyOf(vector.getArrayRef(), this.dim + 1);
        dArray[this.dim] = 0.0;
        return new Vector(dArray);
    }

    public double[] homogeneRelativeVector(double[] dArray) {
        assert (dArray.length == this.dim);
        double[] dArray2 = Arrays.copyOf(dArray, this.dim + 1);
        dArray2[this.dim] = 0.0;
        return dArray2;
    }

    public Vector unhomogeneVector(Vector vector) {
        assert (vector.getDimensionality() == this.dim + 1);
        double[] dArray = new double[this.dim];
        double d = vector.get(this.dim);
        assert (Math.abs(d) > 0.0);
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = vector.get(i) / d;
        }
        return new Vector(dArray);
    }

    public double[] unhomogeneVector(double[] dArray) {
        assert (dArray.length == this.dim + 1);
        double[] dArray2 = new double[this.dim];
        double d = dArray[this.dim];
        assert (Math.abs(d) > 0.0);
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    public Vector unhomogeneRelativeVector(Vector vector) {
        assert (vector.getDimensionality() == this.dim + 1);
        double[] dArray = new double[this.dim];
        assert (Math.abs(vector.get(this.dim)) < Double.MIN_NORMAL);
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = vector.get(i);
        }
        return new Vector(dArray);
    }

    public double[] unhomogeneRelativeVector(double[] dArray) {
        assert (dArray.length == this.dim + 1);
        double[] dArray2 = new double[this.dim];
        System.arraycopy(dArray, 0, dArray2, 0, this.dim);
        assert (Math.abs(dArray[this.dim]) < Double.MIN_NORMAL);
        return dArray2;
    }

    public Vector apply(Vector vector) {
        return this.unhomogeneVector(this.trans.times(this.homogeneVector(vector)));
    }

    public double[] apply(double[] dArray) {
        return this.unhomogeneVector(VMath.times(this.trans.elements, this.homogeneVector(dArray)));
    }

    public Vector applyInverse(Vector vector) {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.unhomogeneVector(this.inv.times(this.homogeneVector(vector)));
    }

    public double[] applyInverse(double[] dArray) {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.unhomogeneVector(VMath.times(this.inv.elements, this.homogeneVector(dArray)));
    }

    public Vector applyRelative(Vector vector) {
        return this.unhomogeneRelativeVector(this.trans.times(this.homogeneRelativeVector(vector)));
    }

    public double[] applyRelative(double[] dArray) {
        return this.unhomogeneRelativeVector(VMath.times(this.trans.elements, this.homogeneRelativeVector(dArray)));
    }

    public Vector applyRelativeInverse(Vector vector) {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.unhomogeneRelativeVector(this.inv.times(this.homogeneRelativeVector(vector)));
    }

    public double[] applyRelativeInverse(double[] dArray) {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.unhomogeneRelativeVector(VMath.times(this.inv.elements, this.homogeneRelativeVector(dArray)));
    }
}

