/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.util.Arrays;

public class CovarianceMatrix {
    public static final String ERR_TOO_LITTLE_WEIGHT = "Too few elements (too little total weight) used to obtain a valid covariance matrix.";
    double[] mean;
    double[][] elements;
    double[] nmea;
    protected double wsum;

    public CovarianceMatrix(int n) {
        this.mean = new double[n];
        this.nmea = new double[n];
        this.elements = new double[n][n];
        this.wsum = 0.0;
    }

    public int getDimensionality() {
        return this.mean.length;
    }

    public void put(double[] dArray) {
        int n;
        assert (dArray.length == this.mean.length);
        double d = this.wsum + 1.0;
        for (n = 0; n < this.mean.length; ++n) {
            double d2 = dArray[n] - this.mean[n];
            this.nmea[n] = this.mean[n] + d2 / d;
        }
        for (n = 0; n < this.mean.length; ++n) {
            for (int i = n; i < this.mean.length; ++i) {
                double d3 = (dArray[n] - this.nmea[n]) * (dArray[i] - this.mean[i]);
                this.elements[n][i] = this.elements[n][i] + d3;
                if (n == i) continue;
                this.elements[i][n] = this.elements[i][n] + d3;
            }
        }
        this.wsum = d;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public void put(double[] dArray, double d) {
        int n;
        assert (dArray.length == this.mean.length);
        double d2 = this.wsum + d;
        for (n = 0; n < this.mean.length; ++n) {
            double d3 = dArray[n] - this.mean[n];
            double d4 = d3 * d / d2;
            this.nmea[n] = this.mean[n] + d4;
        }
        for (n = 0; n < this.mean.length; ++n) {
            for (int i = n; i < this.mean.length; ++i) {
                double d5 = (dArray[n] - this.nmea[n]) * (dArray[i] - this.mean[i]) * d;
                this.elements[n][i] = this.elements[n][i] + d5;
                if (n == i) continue;
                this.elements[i][n] = this.elements[i][n] + d5;
            }
        }
        this.wsum = d2;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public final void put(Vector vector) {
        this.put(vector.getArrayRef());
    }

    public final void put(Vector vector, double d) {
        this.put(vector.getArrayRef(), d);
    }

    public void put(NumberVector numberVector) {
        int n;
        assert (numberVector.getDimensionality() == this.mean.length);
        double d = this.wsum + 1.0;
        for (n = 0; n < this.mean.length; ++n) {
            double d2 = numberVector.doubleValue(n) - this.mean[n];
            this.nmea[n] = this.mean[n] + d2 / d;
        }
        for (n = 0; n < this.mean.length; ++n) {
            for (int i = n; i < this.mean.length; ++i) {
                double d3 = (numberVector.doubleValue(n) - this.nmea[n]) * (numberVector.doubleValue(i) - this.mean[i]);
                this.elements[n][i] = this.elements[n][i] + d3;
                if (n == i) continue;
                this.elements[i][n] = this.elements[i][n] + d3;
            }
        }
        this.wsum = d;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public void put(NumberVector numberVector, double d) {
        int n;
        assert (numberVector.getDimensionality() == this.mean.length);
        double d2 = this.wsum + d;
        for (n = 0; n < this.mean.length; ++n) {
            double d3 = numberVector.doubleValue(n) - this.mean[n];
            double d4 = d3 * d / d2;
            this.nmea[n] = this.mean[n] + d4;
        }
        for (n = 0; n < this.mean.length; ++n) {
            for (int i = n; i < this.mean.length; ++i) {
                double d5 = (numberVector.doubleValue(n) - this.nmea[n]) * (numberVector.doubleValue(i) - this.mean[i]) * d;
                this.elements[n][i] = this.elements[n][i] + d5;
                if (n == i) continue;
                this.elements[i][n] = this.elements[i][n] + d5;
            }
        }
        this.wsum = d2;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public double getWeight() {
        return this.wsum;
    }

    public Vector getMeanVector() {
        return new Vector(this.mean);
    }

    public <F extends NumberVector> F getMeanVector(Relation<? extends F> relation) {
        return RelationUtil.getNumberVectorFactory(relation).newNumberVector(this.mean);
    }

    public Matrix makeSampleMatrix() {
        if (this.wsum <= 1.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        Matrix matrix = new Matrix(this.elements);
        return matrix.times(1.0 / (this.wsum - 1.0));
    }

    public Matrix makeNaiveMatrix() {
        if (this.wsum <= 0.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        Matrix matrix = new Matrix(this.elements);
        return matrix.times(1.0 / this.wsum);
    }

    public Matrix destroyToSampleMatrix() {
        if (this.wsum <= 1.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        Matrix matrix = new Matrix(this.elements).timesEquals(1.0 / (this.wsum - 1.0));
        this.elements = null;
        return matrix;
    }

    public Matrix destroyToNaiveMatrix() {
        if (this.wsum <= 0.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        Matrix matrix = new Matrix(this.elements).timesEquals(1.0 / this.wsum);
        this.elements = null;
        return matrix;
    }

    public void reset() {
        Arrays.fill(this.mean, 0.0);
        Arrays.fill(this.nmea, 0.0);
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                Arrays.fill(this.elements[i], 0.0);
            }
        } else {
            this.elements = new double[this.mean.length][this.mean.length];
        }
        this.wsum = 0.0;
    }

    public static CovarianceMatrix make(Matrix matrix) {
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(matrix.getRowDimensionality());
        int n = matrix.getColumnDimensionality();
        for (int i = 0; i < n; ++i) {
            covarianceMatrix.put(matrix.getCol(i));
        }
        return covarianceMatrix;
    }

    public static CovarianceMatrix make(Relation<? extends NumberVector> relation) {
        Object object;
        int n = RelationUtil.dimensionality(relation);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(n);
        double[] dArray = covarianceMatrix.mean;
        int n2 = 0;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            object = relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + object.doubleValue(i);
            }
            ++n2;
            dBIDIter.advance();
        }
        if (n2 == 0) {
            return covarianceMatrix;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        double[] dArray2 = covarianceMatrix.nmea;
        object = covarianceMatrix.elements;
        DBIDIter dBIDIter2 = relation.iterDBIDs();
        while (dBIDIter2.valid()) {
            int n6;
            NumberVector numberVector = relation.get(dBIDIter2);
            for (n6 = 0; n6 < n; ++n6) {
                dArray2[n6] = numberVector.doubleValue(n6) - dArray[n6];
            }
            for (n6 = 0; n6 < n; ++n6) {
                for (int i = n6; i < n; ++i) {
                    Object object2 = object[n6];
                    int n7 = i;
                    object2[n7] = object2[n7] + dArray2[n6] * dArray2[i];
                }
            }
            dBIDIter2.advance();
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                object[j][i] = object[i][j];
            }
        }
        covarianceMatrix.wsum = n2;
        return covarianceMatrix;
    }

    public static CovarianceMatrix make(Relation<? extends NumberVector> relation, DBIDs dBIDs) {
        Object object;
        int n = RelationUtil.dimensionality(relation);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(n);
        double[] dArray = covarianceMatrix.mean;
        int n2 = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            object = relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + object.doubleValue(i);
            }
            ++n2;
            dBIDIter.advance();
        }
        if (n2 == 0) {
            return covarianceMatrix;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        double[] dArray2 = covarianceMatrix.nmea;
        object = covarianceMatrix.elements;
        DBIDIter dBIDIter2 = dBIDs.iter();
        while (dBIDIter2.valid()) {
            int n6;
            NumberVector numberVector = relation.get(dBIDIter2);
            for (n6 = 0; n6 < n; ++n6) {
                dArray2[n6] = numberVector.doubleValue(n6) - dArray[n6];
            }
            for (n6 = 0; n6 < n; ++n6) {
                for (int i = n6; i < n; ++i) {
                    Object object2 = object[n6];
                    int n7 = i;
                    object2[n7] = object2[n7] + dArray2[n6] * dArray2[i];
                }
            }
            dBIDIter2.advance();
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                object[j][i] = object[i][j];
            }
        }
        covarianceMatrix.wsum = n2;
        return covarianceMatrix;
    }
}

