/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.fitting;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunctionResult;

public class GaussianFittingFunction
implements FittingFunction {
    public static final GaussianFittingFunction STATIC = new GaussianFittingFunction();

    @Override
    public FittingFunctionResult eval(double d, double[] dArray) {
        int n = dArray.length;
        assert (n % 3 == 0);
        double d2 = 0.0;
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray.length; i += 3) {
            double d3 = (d - dArray[i]) / dArray[i + 1];
            double d4 = Math.exp(-0.5 * d3 * d3);
            double d5 = dArray[i + 2] / (dArray[i + 1] * MathUtil.SQRTTWOPI) * d4;
            d2 += d5;
            dArray2[i] = d5 * d3;
            dArray2[i + 1] = (d3 * d3 - 1.0) * d5;
            dArray2[i + 2] = d4 / (dArray[i + 1] * MathUtil.SQRTTWOPI);
        }
        return new FittingFunctionResult(d2, dArray2);
    }
}

