/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.WeakEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.ArrayList;

@Title(value="Progressive Eigenpair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns the first eigenpairs, whose sum of eigenvalues explains more than the a certain percentage of the unexpected variance, where the percentage increases with subspace dimensionality.")
public class ProgressiveEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_PALPHA = 0.5;
    public static final double DEFAULT_WALPHA = 0.95;
    private double palpha;
    private double walpha;

    public ProgressiveEigenPairFilter(double d, double d2) {
        this.palpha = d;
        this.walpha = d2;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        EigenPair eigenPair;
        int n;
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        double d = 0.0;
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair2 = sortedEigenPairs.getEigenPair(i);
            d += eigenPair2.getEigenvalue();
        }
        double d2 = d / (double)sortedEigenPairs.size() * this.walpha;
        double d3 = 0.0;
        boolean bl = false;
        for (n = 0; n < sortedEigenPairs.size() && !((eigenPair = sortedEigenPairs.getEigenPair(n)).getEigenvalue() < d2); ++n) {
            double d4;
            if (!((d3 += eigenPair.getEigenvalue()) / d >= (d4 = 1.0 - (1.0 - this.palpha) * (1.0 - (double)((n + 1) / sortedEigenPairs.size())))) && n != sortedEigenPairs.size() - 1) continue;
            bl = true;
            arrayList.add(eigenPair);
            break;
        }
        if (!bl) {
            assert (arrayList2.size() == 0);
            arrayList2 = arrayList;
            arrayList = new ArrayList();
        }
        while (n < sortedEigenPairs.size()) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList2.add(eigenPair);
            ++n;
        }
        if (arrayList.size() == 0) {
            return new FilteredEigenPairs(new ArrayList<EigenPair>(), arrayList2);
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_PALPHA = new OptionID("pca.filter.progressivealpha", "The share (0.0 to 1.0) of variance that needs to be explained by the 'strong' eigenvectors.The filter class will choose the number of strong eigenvectors by this share.");
        private double palpha;
        private double walpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(EIGENPAIR_FILTER_PALPHA, 0.5);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.palpha = (Double)doubleParameter.getValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(WeakEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_WALPHA, 0.95);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.walpha = (Double)doubleParameter2.getValue();
            }
        }

        @Override
        protected ProgressiveEigenPairFilter makeInstance() {
            return new ProgressiveEigenPairFilter(this.palpha, this.walpha);
        }
    }
}

