/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections;

import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="M. Datar and N. Immorlica and P. Indyk and V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th Symposium on Computational Geometry", url="http://dx.doi.org/10.1145/997817.997857")
public class GaussianRandomProjectionFamily
extends AbstractRandomProjectionFamily {
    public GaussianRandomProjectionFamily(RandomFactory randomFactory) {
        super(randomFactory);
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int n, int n2) {
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n; ++j) {
                dArray2[j] = this.random.nextGaussian();
            }
        }
        return new AbstractRandomProjectionFamily.MatrixProjection(dArray);
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        @Override
        protected GaussianRandomProjectionFamily makeInstance() {
            return new GaussianRandomProjectionFamily(this.random);
        }
    }
}

