/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.scales;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public final class Scales {
    private Scales() {
    }

    public static LinearScale[] calcScales(Relation<? extends SpatialComparable> relation) {
        if (relation == null) {
            throw new AbortException("No database was given to Scales.calcScales.");
        }
        int n = RelationUtil.dimensionality(relation);
        DoubleMinMax[] doubleMinMaxArray = DoubleMinMax.newArray(n);
        LinearScale[] linearScaleArray = new LinearScale[n];
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d;
            int n2;
            SpatialComparable spatialComparable = relation.get(dBIDIter);
            if (spatialComparable instanceof NumberVector) {
                for (n2 = 0; n2 < n; ++n2) {
                    d = spatialComparable.getMin(n2);
                    if (d != d) continue;
                    doubleMinMaxArray[n2].put(d);
                }
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    double d2;
                    d = spatialComparable.getMin(n2);
                    if (d == d) {
                        doubleMinMaxArray[n2].put(d);
                    }
                    if ((d2 = spatialComparable.getMax(n2)) != d2) continue;
                    doubleMinMaxArray[n2].put(d2);
                }
            }
            dBIDIter.advance();
        }
        for (int i = 0; i < n; ++i) {
            linearScaleArray[i] = new LinearScale(doubleMinMaxArray[i].getMin(), doubleMinMaxArray[i].getMax());
        }
        return linearScaleArray;
    }
}

