/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import java.util.Arrays;

public class ZCurveTransformer {
    private final double[] maxValues;
    private final double[] minValues;
    private final int dimensionality;

    public ZCurveTransformer(Relation<? extends NumberVector> relation, DBIDs dBIDs) {
        this.dimensionality = RelationUtil.dimensionality(relation);
        this.minValues = new double[this.dimensionality];
        this.maxValues = new double[this.dimensionality];
        Arrays.fill(this.minValues, Double.POSITIVE_INFINITY);
        Arrays.fill(this.maxValues, Double.NEGATIVE_INFINITY);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            for (int i = 0; i < this.dimensionality; ++i) {
                double d = numberVector.doubleValue(i);
                this.minValues[i] = Math.min(this.minValues[i], d);
                this.maxValues[i] = Math.max(this.maxValues[i], d);
            }
            dBIDIter.advance();
        }
    }

    public byte[] asByteArray(NumberVector numberVector) {
        long[] lArray = new long[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            double d = this.minValues[i];
            double d2 = this.maxValues[i];
            double d3 = numberVector.doubleValue(i);
            d3 = (d3 - d) / (d2 - d);
            lArray[i] = (long)(d3 * 9.223372036854776E18);
        }
        byte[] byArray = new byte[64 * this.dimensionality * 8];
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < this.dimensionality; ++j) {
                long l = lArray[j];
                int n2 = n % 8;
                int n3 = byArray.length - 1 - n / 8;
                byArray[n3] = (byte)((long)byArray[n3] | (l >> i & 1L) << n2);
                ++n;
            }
        }
        return byArray;
    }
}

