/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.List;

public class CorrelationDependenceMeasure
extends AbstractDependenceMeasure {
    private static final Logging LOG = Logging.getLogger(CorrelationDependenceMeasure.class);
    public static final CorrelationDependenceMeasure STATIC = new CorrelationDependenceMeasure();

    protected CorrelationDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = CorrelationDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += numberArrayAdapter.getDouble(a, i);
            d2 += numberArrayAdapter2.getDouble(b, i);
        }
        d /= (double)n;
        d2 /= (double)n;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d6 = numberArrayAdapter.getDouble(a, i) - d;
            double d7 = numberArrayAdapter2.getDouble(b, i) - d2;
            d3 += d6 * d6;
            d4 += d7 * d7;
            d5 += d6 * d7;
        }
        return d5 / Math.sqrt(d3 * d4);
    }

    @Override
    public <A> double[] dependence(NumberArrayAdapter<?, A> numberArrayAdapter, List<? extends A> list) {
        int n;
        int n2;
        int n3;
        int n4 = list.size();
        int n5 = CorrelationDependenceMeasure.size(numberArrayAdapter, list);
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            double d = 0.0;
            A a = list.get(i);
            for (n3 = 0; n3 < n5; ++n3) {
                d += numberArrayAdapter.getDouble(a, n3);
            }
            dArray[i] = d / (double)n5;
        }
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4 * (n4 - 1) >> 1];
        double[] dArray4 = new double[n4];
        for (n2 = 0; n2 < n5; ++n2) {
            for (n3 = 0; n3 < n4; ++n3) {
                dArray4[n3] = numberArrayAdapter.getDouble(list.get(n3), n2) - dArray[n3];
            }
            n = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n3; ++i) {
                    int n6 = n++;
                    dArray3[n6] = dArray3[n6] + dArray4[i] * dArray4[n3];
                }
                int n7 = n3;
                dArray2[n7] = dArray2[n7] + dArray4[n3] * dArray4[n3];
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (dArray2[n2] == 0.0) {
                LOG.warning("Correlation is not well defined for constant attributes.");
            }
            dArray2[n2] = Math.sqrt(dArray2[n2]);
        }
        n3 = 0;
        for (n2 = 1; n2 < n4; ++n2) {
            for (n = 0; n < n2; ++n) {
                dArray3[n3] = dArray3[n3] / (dArray2[n] * dArray2[n2]);
                ++n3;
            }
        }
        return dArray3;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CorrelationDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

