/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class SlopeDependenceMeasure
extends AbstractDependenceMeasure {
    public static final SlopeDependenceMeasure STATIC = new SlopeDependenceMeasure();
    protected static final int PRECISION = 40;
    protected static final double LOG_PRECISION = Math.log(40.0);
    protected static final double RESCALE = 20.0;

    protected SlopeDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        double d;
        int n;
        double d2;
        int n2 = SlopeDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        double d3 = d2 = numberArrayAdapter.getDouble(a, 0);
        for (n = 1; n < n2; ++n) {
            d = numberArrayAdapter.getDouble(a, n);
            if (d < d2) {
                d2 = d;
                continue;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        double d4 = d2;
        double d5 = d3 > d2 ? 1.0 / (d3 - d2) : 1.0;
        d3 = d2 = numberArrayAdapter2.getDouble(b, 0);
        for (n = 1; n < n2; ++n) {
            d = numberArrayAdapter2.getDouble(b, n);
            if (d < d2) {
                d2 = d;
                continue;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        double d6 = d2;
        double d7 = d3 > d2 ? 1.0 / (d3 - d2) : 1.0;
        int[] nArray = new int[40];
        for (int i = 0; i < n2; ++i) {
            d3 = numberArrayAdapter.getDouble(a, i);
            double d8 = numberArrayAdapter2.getDouble(b, i);
            double d9 = (d3 = (d3 - d4) * d5) - (d8 = (d8 - d6) * d7) + 1.0;
            int n3 = (int)Math.round(d9 * 20.0);
            int n4 = n3 = n3 < 0 ? 0 : (n3 >= 40 ? 39 : n3);
            nArray[n4] = nArray[n4] + 1;
        }
        double d10 = 0.0;
        for (int i = 0; i < 40; ++i) {
            if (nArray[i] <= 0) continue;
            double d11 = (double)nArray[i] / (double)n2;
            d10 += d11 * Math.log(d11);
        }
        return 1.0 + d10 / LOG_PRECISION;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SlopeDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

