/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.ProbabilityWeightedMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Arrays;

public abstract class AbstractLMMEstimator<D extends Distribution>
implements LMMDistributionEstimator<D> {
    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberArrayAdapter.getDouble(a, i);
        }
        Arrays.sort(dArray);
        double[] dArray2 = ProbabilityWeightedMoments.samLMR(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER, this.getNumMoments());
        return this.estimateFromLMoments(dArray2);
    }

    @Override
    public abstract D estimateFromLMoments(double[] var1);

    @Override
    public abstract int getNumMoments();

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

