/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public abstract class AbstractLogMOMEstimator<D extends Distribution>
implements LogMOMDistributionEstimator<D> {
    @Override
    public abstract D estimateFromLogStatisticalMoments(StatisticalMoments var1, double var2);

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double d = AbstractLogMOMEstimator.min(a, numberArrayAdapter, 0.0, 1.0E-10);
        StatisticalMoments statisticalMoments = new StatisticalMoments();
        for (int i = 0; i < n; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i) - d;
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 <= 0.0) continue;
            statisticalMoments.put(Math.log(d2));
        }
        return this.estimateFromLogStatisticalMoments(statisticalMoments, d);
    }

    public static <A> double min(A a, NumberArrayAdapter<?, A> numberArrayAdapter, double d, double d2) {
        double d3;
        int n = numberArrayAdapter.size(a);
        double d4 = d3 = numberArrayAdapter.getDouble(a, 0);
        for (int i = 1; i < n; ++i) {
            double d5 = numberArrayAdapter.getDouble(a, i);
            if (d5 < d3) {
                d3 = d5;
                continue;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        if (d3 > d) {
            return d;
        }
        return d3 - (d4 - d3) * d2;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

