/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Maximum likelihood estimation of the parameters of the gamma distribution and their bias", authors="S. C. Choi, R. Wette", booktitle="Technometrics", url="http://www.jstor.org/stable/10.2307/1266892")
public class GammaChoiWetteEstimator
implements DistributionEstimator<GammaDistribution> {
    public static final GammaChoiWetteEstimator STATIC = new GammaChoiWetteEstimator();

    private GammaChoiWetteEstimator() {
    }

    @Override
    public <A> GammaDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double d;
        int n = numberArrayAdapter.size(a);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = numberArrayAdapter.getDouble(a, i);
            if (d4 <= 0.0 || Double.isInfinite(d4) || Double.isNaN(d4)) continue;
            double d5 = d4 > 0.0 ? Math.log(d4) : d3;
            double d6 = d4 - d2;
            double d7 = d5 - d3;
            d2 += d6 / ((double)i + 1.0);
            d3 += d7 / ((double)i + 1.0);
        }
        double d8 = d2 > 0.0 ? Math.log(d2) : d3;
        double d9 = d8 - d3;
        double d10 = (3.0 - d9 + Math.sqrt((d9 - 3.0) * (d9 - 3.0) + 24.0 * d9)) / (12.0 * d9);
        while (!(Math.abs(d = (Math.log(d10) - GammaDistribution.digamma(d10) - d9) / (1.0 / d10 - GammaDistribution.trigamma(d10))) / d10 < 1.0E-8) && d < Double.POSITIVE_INFINITY) {
            d10 += d;
        }
        d = d10 / d2;
        if (!(d10 > 0.0) || !(d > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + d10 + " theta=" + d);
        }
        return new GammaDistribution(d10, d);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaChoiWetteEstimator makeInstance() {
            return STATIC;
        }
    }
}

