/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GumbelDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class GumbelMADEstimator
extends AbstractMADEstimator<GumbelDistribution> {
    public static final GumbelMADEstimator STATIC = new GumbelMADEstimator();

    private GumbelMADEstimator() {
    }

    @Override
    public GumbelDistribution estimateFromMedianMAD(double d, double d2) {
        return new GumbelDistribution(d + 0.4778 * d2, 1.3037 * d2);
    }

    @Override
    public Class<? super GumbelDistribution> getDistributionClass() {
        return GumbelDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GumbelMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

