/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogGammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Maximum likelihood estimation of the parameters of the gamma distribution and their bias", authors="S. C. Choi, R. Wette", booktitle="Technometrics", url="http://www.jstor.org/stable/10.2307/1266892")
public class LogGammaChoiWetteEstimator
implements DistributionEstimator<LogGammaDistribution> {
    public static final LogGammaChoiWetteEstimator STATIC = new LogGammaChoiWetteEstimator();

    private LogGammaChoiWetteEstimator() {
    }

    @Override
    public <A> LogGammaDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double d;
        int n = numberArrayAdapter.size(a);
        double d2 = AbstractLogMOMEstimator.min(a, numberArrayAdapter, 0.0, 1.0E-10);
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = numberArrayAdapter.getDouble(a, i) - d2;
            if (d5 <= 0.0 || Double.isInfinite(d5) || Double.isNaN(d5)) continue;
            double d6 = (d5 = Math.log(d5)) > 0.0 ? Math.log(d5) : d4;
            double d7 = d5 - d3;
            double d8 = d6 - d4;
            d3 += d7 / ((double)i + 1.0);
            d4 += d8 / ((double)i + 1.0);
        }
        if (!(d3 > 0.0)) {
            throw new ArithmeticException("Cannot estimate LogGamma distribution with mean " + d3);
        }
        double d9 = Math.log(d3);
        double d10 = d9 - d4;
        double d11 = (3.0 - d10 + Math.sqrt((d10 - 3.0) * (d10 - 3.0) + 24.0 * d10)) / (12.0 * d10);
        while (!(Math.abs(d = (Math.log(d11) - GammaDistribution.digamma(d11) - d10) / (1.0 / d11 - GammaDistribution.trigamma(d11))) / d11 < 1.0E-8) && d < Double.POSITIVE_INFINITY && d > Double.NEGATIVE_INFINITY) {
            d11 += d;
        }
        d = d11 / d3;
        if (!(d11 > 0.0) || !(d > 0.0)) {
            throw new ArithmeticException("LogGamma estimation produced non-positive parameter values: k=" + d11 + " theta=" + d);
        }
        return new LogGammaDistribution(d11, d, d2 - 1.0);
    }

    @Override
    public Class<? super LogGammaDistribution> getDistributionClass() {
        return LogGammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogGammaChoiWetteEstimator makeInstance() {
            return STATIC;
        }
    }
}

