/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class UniformMADEstimator
extends AbstractMADEstimator<UniformDistribution> {
    public static final UniformMADEstimator STATIC = new UniformMADEstimator();

    private UniformMADEstimator() {
    }

    @Override
    public UniformDistribution estimateFromMedianMAD(double d, double d2) {
        return new UniformDistribution(Math.max(d - 2.0 * d2, -1.7976931348623157E308), Math.min(d + 2.0 * d2, Double.MAX_VALUE));
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

