/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.WeibullDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class WeibullLogMADEstimator
extends AbstractLogMADEstimator<WeibullDistribution> {
    public static final WeibullLogMADEstimator STATIC = new WeibullLogMADEstimator();

    private WeibullLogMADEstimator() {
    }

    @Override
    public WeibullDistribution estimateFromLogMedianMAD(double d, double d2, double d3) {
        double d4 = 1.3037 / d2;
        double d5 = Math.exp(d4 * d - MathUtil.LOGLOG2);
        return new WeibullDistribution(d4, d5);
    }

    @Override
    public Class<? super WeibullDistribution> getDistributionClass() {
        return WeibullDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WeibullLogMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

