/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M. E. Houle, H. Kashima, M. Nett", title="Generalized expansion dimension", booktitle="12th International Conference on Data Mining Workshops (ICDMW)", url="http://dx.doi.org/10.1109/ICDMW.2012.94")
public class GEDEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final GEDEstimator STATIC = new GEDEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        int n2 = n - 1;
        double[] dArray = new double[n2 << 1];
        for (int i = 0; i < n2; ++i) {
            double d = Math.log(numberArrayAdapter.getDouble(a, i));
            double d2 = Math.log1p(i);
            int n3 = i;
            for (int j = i + 1; j < n; ++j) {
                double d3 = Math.log(numberArrayAdapter.getDouble(a, j));
                if (d == d3) continue;
                double d4 = (d2 - Math.log1p(j)) / (d - d3);
                dArray[n3++] = d4;
            }
            dArray[i] = QuickSelect.median(dArray, i, n3);
        }
        return QuickSelect.median(dArray, 0, n2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GEDEstimator makeInstance() {
            return STATIC;
        }
    }
}

