/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.StudentsTDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class WelchTTest
implements GoodnessOfFitTest {
    public static final WelchTTest STATIC = new WelchTTest();

    @Override
    public double deviation(double[] dArray, double[] dArray2) {
        MeanVariance meanVariance = new MeanVariance();
        MeanVariance meanVariance2 = new MeanVariance();
        for (double d : dArray) {
            meanVariance.put(d);
        }
        for (double d : dArray2) {
            meanVariance2.put(d);
        }
        double d = WelchTTest.calculateTestStatistic(meanVariance, meanVariance2);
        int n = WelchTTest.calculateDOF(meanVariance, meanVariance2);
        return 1.0 - WelchTTest.calculatePValue(d, n);
    }

    public static double calculateTestStatistic(MeanVariance meanVariance, MeanVariance meanVariance2) {
        double d = meanVariance.getMean() - meanVariance2.getMean();
        double d2 = meanVariance.getSampleVariance() / meanVariance.getCount();
        double d3 = meanVariance2.getSampleVariance() / meanVariance2.getCount();
        return d / Math.sqrt(d2 + d3);
    }

    public static int calculateDOF(MeanVariance meanVariance, MeanVariance meanVariance2) {
        double d = meanVariance.getSampleVariance() / meanVariance.getCount();
        double d2 = meanVariance2.getSampleVariance() / meanVariance2.getCount();
        double d3 = d + d2;
        double d4 = d * d / (meanVariance.getCount() - 1.0) + d2 * d2 / (meanVariance2.getCount() - 1.0);
        return (int)(d3 * d3 / d4);
    }

    public static double calculatePValue(double d, int n) {
        return 2.0 * (1.0 - StudentsTDistribution.cdf(Math.abs(d), n));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WelchTTest makeInstance() {
            return STATIC;
        }
    }
}

