/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.OnDiskArray;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OnDiskUpperTriangleMatrix {
    private static final long serialVersionUID = -4489942156357634702L;
    private static final int TRIANGLE_HEADER_SIZE = 4;
    private int matrixsize;
    private OnDiskArray array;

    public OnDiskUpperTriangleMatrix(File file, int n, int n2, int n3, boolean bl) throws IOException {
        this.array = new OnDiskArray(file, OnDiskArray.mixMagic(-1002408590, n), n2 + 4, n3, bl);
        ByteBuffer byteBuffer = this.array.getExtraHeader();
        this.matrixsize = byteBuffer.getInt();
        if (OnDiskUpperTriangleMatrix.arraysize(this.matrixsize) != this.array.getNumRecords()) {
            throw new IOException("Matrix file size doesn't match specified dimensions: " + this.matrixsize + "->" + OnDiskUpperTriangleMatrix.arraysize(this.matrixsize) + " vs. " + this.array.getNumRecords());
        }
    }

    public OnDiskUpperTriangleMatrix(File file, int n, int n2, int n3, int n4) throws IOException {
        if (n4 >= 65535) {
            throw new RuntimeException("Matrix size is too big and will overflow the integer datatype.");
        }
        this.matrixsize = n4;
        this.array = new OnDiskArray(file, OnDiskArray.mixMagic(-1002408590, n), n2 + 4, n3, OnDiskUpperTriangleMatrix.arraysize(n4));
        ByteBuffer byteBuffer = this.array.getExtraHeader();
        byteBuffer.putInt(this.matrixsize);
    }

    public synchronized void resizeMatrix(int n) throws IOException {
        if (n >= 65535) {
            throw new RuntimeException("Matrix size is too big and will overflow the integer datatype.");
        }
        if (!this.array.isWritable()) {
            throw new IOException("Can't resize a read-only array.");
        }
        this.array.resizeFile(OnDiskUpperTriangleMatrix.arraysize(n));
        this.matrixsize = n;
        ByteBuffer byteBuffer = this.array.getExtraHeader();
        byteBuffer.putInt(this.matrixsize);
    }

    private static int arraysize(int n) {
        return n * (n + 1) >> 1;
    }

    private int computeOffset(int n, int n2) {
        if (n2 > n) {
            return this.computeOffset(n2, n);
        }
        return (n * (n + 1) >> 1) + n2;
    }

    public synchronized ByteBuffer getRecordBuffer(int n, int n2) throws IOException {
        if (n >= this.matrixsize || n2 >= this.matrixsize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array.getRecordBuffer(this.computeOffset(n, n2));
    }

    public synchronized void close() throws IOException {
        this.array.close();
    }

    public int getMatrixSize() {
        return this.matrixsize;
    }
}

