/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class ClusteringVectorDumper
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ClusteringVectorDumper.class);
    private File outputFile;
    private String forceLabel;
    private boolean append;

    public ClusteringVectorDumper(File file, boolean bl, String string) {
        this.outputFile = file;
        this.forceLabel = string;
        this.append = bl;
    }

    public ClusteringVectorDumper(File file, boolean bl) {
        this(file, bl, null);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        if (this.forceLabel != null && this.forceLabel.length() > 0 && list.size() > 1) {
            LOG.warning("Found more than one clustering result, they will have the same (forced) label.");
        }
        if (this.outputFile != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile, this.append);
                 PrintStream printStream = new PrintStream(fileOutputStream);){
                for (Clustering<? extends Model> clustering : list) {
                    this.dumpClusteringOutput(printStream, resultHierarchy, clustering);
                }
                this.append = true;
            }
            catch (IOException iOException) {
                LOG.exception("Error writing to output stream.", iOException);
            }
        } else {
            for (Clustering<? extends Model> clustering : list) {
                this.dumpClusteringOutput(System.out, resultHierarchy, clustering);
            }
        }
    }

    protected void dumpClusteringOutput(PrintStream printStream, ResultHierarchy resultHierarchy, Clustering<?> clustering) {
        Object object;
        Result result;
        DBIDRange dBIDRange = null;
        Object object2 = resultHierarchy.iterParents(clustering);
        while (object2.valid()) {
            result = object2.get();
            if (result instanceof Relation) {
                object = ((Relation)result).getDBIDs();
                if (object instanceof DBIDRange) {
                    dBIDRange = (DBIDRange)object;
                    break;
                }
                LOG.warning("Parent result " + result.getLongName() + " has DBID type " + object.getClass());
            }
            object2.advance();
        }
        if (dBIDRange == null) {
            object2 = resultHierarchy.iterAll();
            while (object2.valid()) {
                result = (Result)object2.get();
                if (result instanceof Database) {
                    object = ((Database)result).getRelation(TypeUtil.ANY, new Object[0]).getDBIDs();
                    if (object instanceof DBIDRange) {
                        dBIDRange = (DBIDRange)object;
                        break;
                    }
                    LOG.warning("Parent result " + result.getLongName() + " has DBID type " + object.getClass());
                }
                object2.advance();
            }
        }
        if (dBIDRange == null) {
            LOG.warning("Cannot dump cluster assignment, as I do not have a well-defined DBIDRange to use for a unique column assignment. DBIDs must be a continuous range.");
            return;
        }
        object2 = DataStoreUtil.makeIntegerStorage(dBIDRange, 1);
        int n = 0;
        for (Cluster cluster : clustering.getAllClusters()) {
            DBIDIter dBIDIter = cluster.getIDs().iter();
            while (dBIDIter.valid()) {
                object2.putInt(dBIDIter, n);
                dBIDIter.advance();
            }
            ++n;
        }
        object = dBIDRange.iter();
        while (object.valid()) {
            if (object.getOffset() > 0) {
                printStream.append(' ');
            }
            printStream.append(Integer.toString(object2.intValue((DBIDRef)object)));
            object.advance();
        }
        if (this.forceLabel != null) {
            if (this.forceLabel.length() > 0) {
                printStream.append(' ').append(this.forceLabel);
            }
        } else {
            printStream.append(' ').append(clustering.getLongName());
        }
        printStream.append('\n');
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID OUT_ID = new OptionID("clustering.output", "Output file name. When not given, the result will be written to stdout.");
        public static final OptionID APPEND_ID = new OptionID("clustering.output.append", "Always append to the output file.");
        public static final OptionID FORCE_LABEL_ID = new OptionID("clustering.label", "Parameter to override the clustering label, mostly to give a more descriptive label.");
        private File outputFile = null;
        private String forceLabel;
        private boolean append;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            StringParameter stringParameter;
            Flag flag;
            super.makeOptions(parameterization);
            FileParameter fileParameter = (FileParameter)new FileParameter(OUT_ID, FileParameter.FileType.OUTPUT_FILE).setOptional(true);
            if (parameterization.grab(fileParameter)) {
                this.outputFile = (File)fileParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(APPEND_ID))) {
                this.append = flag.isTrue();
            }
            if (parameterization.grab(stringParameter = (StringParameter)new StringParameter(FORCE_LABEL_ID).setOptional(true))) {
                this.forceLabel = (String)stringParameter.getValue();
            }
        }

        @Override
        protected ClusteringVectorDumper makeInstance() {
            return new ClusteringVectorDumper(this.outputFile, this.append, this.forceLabel);
        }
    }
}

