/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.outlier;

import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;

public class ProbabilisticOutlierScore
implements OutlierScoreMeta {
    private double actualMinimum = Double.NaN;
    private double actualMaximum = Double.NaN;
    private double theoreticalBaseline = Double.NaN;

    public ProbabilisticOutlierScore() {
        this(Double.NaN, Double.NaN, 0.0);
    }

    public ProbabilisticOutlierScore(double d) {
        this(Double.NaN, Double.NaN, d);
    }

    public ProbabilisticOutlierScore(double d, double d2) {
        this(d, d2, 0.0);
    }

    public ProbabilisticOutlierScore(double d, double d2, double d3) {
        this.actualMinimum = d;
        this.actualMaximum = d2;
        this.theoreticalBaseline = d3;
    }

    @Override
    public double getActualMinimum() {
        return this.actualMinimum;
    }

    @Override
    public double getActualMaximum() {
        return this.actualMaximum;
    }

    @Override
    public double getTheoreticalBaseline() {
        return this.theoreticalBaseline;
    }

    @Override
    public double getTheoreticalMaximum() {
        return 1.0;
    }

    @Override
    public double getTheoreticalMinimum() {
        return 0.0;
    }

    @Override
    public double normalizeScore(double d) {
        return d;
    }

    @Override
    public String getLongName() {
        return "Outlier Score Metadata";
    }

    @Override
    public String getShortName() {
        return "outlier-score-meta";
    }
}

