/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ComparableMinHeap<K extends Comparable<? super K>>
implements ObjectHeap<K> {
    protected Comparable<Object>[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public ComparableMinHeap() {
        Comparable[] comparableArray = (Comparable[])Array.newInstance(Comparable.class, 31);
        this.twoheap = comparableArray;
    }

    public ComparableMinHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        Comparable[] comparableArray = (Comparable[])Array.newInstance(Comparable.class, n2);
        this.twoheap = comparableArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(K k) {
        K k2 = k;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
        }
        int n = this.size++;
        this.twoheap[n] = k2;
        this.heapifyUp(n, (Comparable<Object>)k2);
    }

    @Override
    public void add(K k, int n) {
        if (this.size < n) {
            this.add(k);
        } else if (this.twoheap[0].compareTo(k) < 0) {
            this.replaceTopElement(k);
        }
    }

    @Override
    public K replaceTopElement(K k) {
        Comparable<Object> comparable = this.twoheap[0];
        this.heapifyDown((Comparable<Object>)k);
        return (K)comparable;
    }

    private void heapifyUp(int n, Comparable<Object> comparable) {
        int n2;
        Comparable<Object> comparable2;
        while (n > 0 && comparable.compareTo(comparable2 = this.twoheap[n2 = n - 1 >>> 1]) < 0) {
            this.twoheap[n] = comparable2;
            n = n2;
        }
        this.twoheap[n] = comparable;
    }

    @Override
    public K poll() {
        Comparable<Object> comparable = this.twoheap[0];
        --this.size;
        if (this.size > 0) {
            Comparable<Object> comparable2 = this.twoheap[this.size];
            this.twoheap[this.size] = null;
            this.heapifyDown(comparable2);
        } else {
            this.twoheap[0] = null;
        }
        return (K)comparable;
    }

    private void heapifyDown(Comparable<Object> comparable) {
        int n = this.size >>> 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 << 1) + 1;
            Comparable<Object> comparable2 = this.twoheap[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && comparable2.compareTo(this.twoheap[n4]) > 0) {
                n3 = n4;
                comparable2 = this.twoheap[n4];
            }
            if (comparable.compareTo(comparable2) <= 0) break;
            this.twoheap[n2] = comparable2;
            n2 = n3;
        }
        this.twoheap[n2] = comparable;
    }

    @Override
    public K peek() {
        return (K)this.twoheap[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ComparableMinHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.get()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements ObjectHeap.UnsortedIter<K> {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < ComparableMinHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public K get() {
            return ComparableMinHeap.this.twoheap[this.pos];
        }
    }
}

